/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.deployer.spring;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.karaf.deployer.spring.SpringTransformer;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringURLHandler
extends AbstractURLStreamHandlerService {
    private final Logger logger = LoggerFactory.getLogger(SpringURLHandler.class);
    private static String SYNTAX = "spring: spring-xml-uri";

    public URLConnection openConnection(URL url) throws IOException {
        if (url.getPath() == null || url.getPath().trim().length() == 0) {
            throw new MalformedURLException("Path cannot be null or empty. Syntax: " + SYNTAX);
        }
        this.logger.debug("Spring xml URL is: [" + url.getPath() + "]");
        return new Connection(url);
    }

    public class Connection
    extends URLConnection {
        public Connection(URL url) {
            super(url);
        }

        public void connect() throws IOException {
        }

        public InputStream getInputStream() throws IOException {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                SpringTransformer.transform(new URL(this.url.getPath()), os);
                os.close();
                return new ByteArrayInputStream(os.toByteArray());
            }
            catch (Exception e) {
                SpringURLHandler.this.logger.error("Error opening Spring xml url", (Throwable)e);
                throw (IOException)new IOException("Error opening Spring xml url").initCause(e);
            }
        }
    }
}

