/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management;

import java.io.IOException;
import java.security.Principal;
import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class JaasAuthenticator
implements JMXAuthenticator {
    private String realm;
    private String role;

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Subject authenticate(Object credentials) throws SecurityException {
        if (!(credentials instanceof String[])) {
            throw new IllegalArgumentException("Expected String[2], got " + (credentials != null ? credentials.getClass().getName() : null));
        }
        final String[] params = (String[])credentials;
        if (params.length != 2) {
            throw new IllegalArgumentException("Expected String[2] but length was " + params.length);
        }
        try {
            Subject subject = new Subject();
            LoginContext loginContext = new LoginContext(this.realm, subject, new CallbackHandler(){

                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (int i = 0; i < callbacks.length; ++i) {
                        if (callbacks[i] instanceof NameCallback) {
                            ((NameCallback)callbacks[i]).setName(params[0]);
                            continue;
                        }
                        if (callbacks[i] instanceof PasswordCallback) {
                            ((PasswordCallback)callbacks[i]).setPassword(params[1].toCharArray());
                            continue;
                        }
                        throw new UnsupportedCallbackException(callbacks[i]);
                    }
                }
            });
            loginContext.login();
            if (this.role != null && this.role.length() > 0) {
                String clazz = "org.apache.karaf.jaas.boot.principal.RolePrincipal";
                String name = this.role;
                int idx = this.role.indexOf(58);
                if (idx > 0) {
                    clazz = this.role.substring(0, idx);
                    name = this.role.substring(idx + 1);
                }
                boolean found = false;
                for (Principal p : subject.getPrincipals()) {
                    if (!p.getClass().getName().equals(clazz) || !p.getName().equals(name)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new FailedLoginException("User does not have the required role " + this.role);
                }
            }
            return subject;
        }
        catch (LoginException e) {
            throw new SecurityException("Authentication failed", e);
        }
    }
}

