/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.service.internal;

import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.varia.DenyAllFilter;
import org.ops4j.pax.logging.service.internal.PaxLoggingEventImpl;
import org.ops4j.pax.logging.spi.PaxFilter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class FilterBridgeImpl
extends Filter {
    private ServiceTracker m_tracker;
    private Filter m_fallback;

    public FilterBridgeImpl(BundleContext bundleContext, String name, Filter fallback) {
        this.m_tracker = new ServiceTracker(bundleContext, FilterBridgeImpl.createFilter(bundleContext, name), null);
        this.m_tracker.open();
        this.m_fallback = fallback != null ? fallback : new DenyAllFilter();
    }

    public static org.osgi.framework.Filter createFilter(BundleContext bundleContext, String name) {
        try {
            return bundleContext.createFilter("(&(objectClass=" + PaxFilter.class.getName() + ")" + "(" + "org.ops4j.pax.logging.filter.name" + "=" + name + "))");
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("unable to create layout tracker", e);
        }
    }

    public int decide(LoggingEvent event) {
        PaxFilter filter = (PaxFilter)this.m_tracker.getService();
        if (filter != null) {
            return filter.doFilter(new PaxLoggingEventImpl(event));
        }
        return this.m_fallback.decide(event);
    }
}

