/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.apache.felix.framework.cache.Content;

public class PatchAwareContent
implements Content {
    private final Content content;
    private final File dir;

    public static URL getPatch(String symbolicName, String version, String entry) {
        try {
            File file = PatchAwareContent.getFile(System.getProperty("felix.patch.location"), symbolicName, version, entry);
            return file != null && file.isFile() ? file.toURI().toURL() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static File getFile(String ... paths) {
        File file = null;
        for (String p : paths) {
            if (p == null) {
                return null;
            }
            file = file == null ? new File(p) : new File(file, p);
        }
        return file;
    }

    public PatchAwareContent(Content content, String symbolicName, String version) {
        this(content, PatchAwareContent.getFile(System.getProperty("felix.patch.location"), symbolicName, version));
    }

    public PatchAwareContent(Content content, File dir) {
        this.content = content;
        this.dir = dir;
    }

    public void close() {
        this.content.close();
    }

    public boolean hasEntry(String name) {
        return this.content.hasEntry(name);
    }

    public Enumeration getEntries() {
        return this.content.getEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getEntryAsBytes(String name) {
        InputStream is = null;
        try {
            is = this.getEntryAsStream(name);
            byte[] byArray = PatchAwareContent.getContent(is);
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static byte[] getContent(InputStream is) throws IOException {
        int n;
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        byte[] buf = new byte[4096];
        while ((n = is.read(buf, 0, buf.length)) >= 0) {
            baos.write(buf, 0, n);
        }
        return baos.toByteArray();
    }

    public InputStream getEntryAsStream(String name) throws IOException {
        File file;
        File file2 = file = this.dir != null ? new File(this.dir, name) : null;
        if (file != null && file.isFile()) {
            return new FileInputStream(file);
        }
        return this.content.getEntryAsStream(name);
    }

    public Content getEntryAsContent(String name) {
        Content c = this.content.getEntryAsContent(name);
        return c != null ? new PatchAwareContent(c, this.dir) : null;
    }

    public String getEntryAsNativeLibrary(String name) {
        return this.content.getEntryAsNativeLibrary(name);
    }

    public URL getEntryAsURL(String name) {
        return this.content.getEntryAsURL(name);
    }
}

