/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.AbstractAction;
import org.apache.karaf.shell.console.BundleContextAware;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OsgiCommandSupport
extends AbstractAction
implements Action,
BundleContextAware {
    protected BundleContext bundleContext;
    protected List<ServiceReference> usedReferences;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(CommandSession session) throws Exception {
        this.session = session;
        try {
            Object object = this.doExecute();
            return object;
        }
        finally {
            this.ungetServices();
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected <T> List<T> getAllServices(Class<T> clazz, String filter) throws Exception {
        Collection references = this.getBundleContext().getServiceReferences(clazz, filter);
        if (references == null) {
            return null;
        }
        ArrayList<T> services = new ArrayList<T>();
        for (ServiceReference ref : references) {
            T t = this.getService(ref);
            services.add(t);
        }
        return services;
    }

    protected <T> T getService(Class<T> clazz, ServiceReference reference) {
        return this.getService(reference);
    }

    protected <T> T getService(Class<T> clazz) {
        ServiceReference ref = this.getBundleContext().getServiceReference(clazz);
        if (ref != null) {
            return this.getService(ref);
        }
        return null;
    }

    protected <T> T getService(ServiceReference<T> reference) {
        Object t = this.getBundleContext().getService(reference);
        if (t != null) {
            if (this.usedReferences == null) {
                this.usedReferences = new ArrayList<ServiceReference>();
            }
            this.usedReferences.add(reference);
        }
        return (T)t;
    }

    protected void ungetServices() {
        if (this.usedReferences != null) {
            for (ServiceReference ref : this.usedReferences) {
                this.getBundleContext().ungetService(ref);
            }
        }
    }
}

