/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.monitor.MonitoringService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.wiring.BundleWiring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorServiceImpl
implements MonitoringService,
SynchronousBundleListener {
    private final Felix felix;
    private final ThreadGroup rootThreadGroup;
    private final Map<String, ExecutorService> executors;
    private final Map<String, ThreadGroup> threadGroups;
    private final Map<ThreadGroup, Boolean> allThreadGroups;
    private final Map<ClassLoader, Boolean> classLoaders;

    public MonitorServiceImpl(Felix felix) {
        this.felix = felix;
        this.rootThreadGroup = new ThreadGroup("bundles");
        this.executors = new HashMap<String, ExecutorService>();
        this.threadGroups = new HashMap<String, ThreadGroup>();
        this.allThreadGroups = new WeakHashMap<ThreadGroup, Boolean>();
        this.classLoaders = new WeakHashMap<ClassLoader, Boolean>();
    }

    @Override
    public Future<?> runInContext(Bundle bundle, Runnable run) {
        return this.felix.runInContext((BundleImpl)bundle, run);
    }

    @Override
    public <T> Future<T> runInContext(Bundle bundle, Callable<T> callable) {
        return this.felix.runInContext((BundleImpl)bundle, callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutorService getExecutor(Bundle bundle) {
        ExecutorService executor;
        Map<String, ExecutorService> map = this.executors;
        synchronized (map) {
            String key = bundle.getSymbolicName() + "-" + bundle.getVersion();
            executor = this.executors.get(key);
            if (executor == null) {
                String timeoutStr = (String)this.felix.getConfig().get("felix.threading.timeout");
                long timeout = timeoutStr != null ? Long.parseLong(timeoutStr) : 60L;
                executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, timeout, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new MonitoringThreadFactory(bundle));
            }
            this.executors.put(key, executor);
        }
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ThreadGroup getThreadGroup(Bundle bundle) {
        Map<String, ThreadGroup> map = this.threadGroups;
        synchronized (map) {
            String key = bundle.getSymbolicName() + "-" + bundle.getVersion();
            ThreadGroup tg = this.threadGroups.get(key);
            if (tg == null) {
                tg = new ThreadGroup(this.rootThreadGroup, key);
                this.threadGroups.put(key, tg);
                this.allThreadGroups.put(tg, true);
            }
            return tg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ThreadGroup> getThreadGroups() {
        Map<String, ThreadGroup> map = this.threadGroups;
        synchronized (map) {
            return this.allThreadGroups.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uninstallBundle(Bundle bundle) {
        String key = bundle.getSymbolicName() + "-" + bundle.getVersion();
        Map<String, Object> map = this.executors;
        synchronized (map) {
            ExecutorService executor = this.executors.remove(key);
            if (executor != null) {
                executor.shutdown();
            }
        }
        map = this.threadGroups;
        synchronized (map) {
            ThreadGroup tg = this.threadGroups.remove(key);
            if (tg != null) {
                tg.setDaemon(true);
                try {
                    tg.destroy();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ClassLoader> getClassLoaders() {
        Map<ClassLoader, Boolean> map = this.classLoaders;
        synchronized (map) {
            return this.classLoaders.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClassLoader(ClassLoader classLoader) {
        Map<ClassLoader, Boolean> map = this.classLoaders;
        synchronized (map) {
            this.classLoaders.put(classLoader, true);
        }
    }

    public void start() {
        this.felix.addBundleListener(this.felix, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Map<Object, Object> map = this.executors;
        synchronized (map) {
            for (ExecutorService ex : this.executors.values()) {
                ex.shutdown();
            }
            this.executors.clear();
        }
        map = this.threadGroups;
        synchronized (map) {
            for (ThreadGroup tg : this.threadGroups.values()) {
                tg.setDaemon(true);
                try {
                    tg.destroy();
                }
                catch (Throwable t) {}
            }
            this.threadGroups.clear();
        }
        map = this.classLoaders;
        synchronized (map) {
            this.classLoaders.clear();
        }
    }

    @Override
    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 8 || event.getType() == 16) {
            this.uninstallBundle(event.getBundle());
        }
    }

    class MonitoringThreadFactory
    implements ThreadFactory {
        private final Bundle bundle;
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        MonitoringThreadFactory(Bundle bundle) {
            this.bundle = bundle;
            this.group = MonitorServiceImpl.this.getThreadGroup(bundle);
            this.namePrefix = "pool-" + bundle.getSymbolicName() + "-" + bundle.getVersion().toString() + "-thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            t.setContextClassLoader(this.bundle.adapt(BundleWiring.class).getClassLoader());
            return t;
        }
    }
}

