/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.proxy.impl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.aries.proxy.InvocationListener;
import org.apache.aries.proxy.ProxyManager;
import org.apache.aries.proxy.UnableToProxyException;
import org.apache.aries.proxy.impl.AbstractProxyManager;
import org.apache.aries.proxy.impl.ProxyHandler;
import org.apache.aries.proxy.impl.gen.ProxySubclassGenerator;
import org.apache.aries.proxy.impl.interfaces.InterfaceProxyGenerator;
import org.apache.aries.proxy.weaving.WovenProxy;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsmProxyManager
extends AbstractProxyManager
implements ProxyManager {
    static final ClassLoader bootClassLoader = new ClassLoader(Object.class.getClassLoader()){};

    @Override
    public Object createNewProxy(Bundle clientBundle, Collection<Class<?>> classes, Callable<Object> dispatcher, InvocationListener listener) throws UnableToProxyException {
        Object proxyObject = null;
        HashSet notInterfaces = new HashSet();
        HashSet interfaces = new HashSet();
        for (Class<?> clazz : classes) {
            if (!clazz.isInterface()) {
                notInterfaces.add(clazz);
                continue;
            }
            interfaces.add(clazz);
        }
        if (notInterfaces.isEmpty()) {
            proxyObject = InterfaceProxyGenerator.getProxyInstance(clientBundle, null, interfaces, dispatcher, listener);
        } else {
            Class<?> classToProxy = this.getLowestSubclass(notInterfaces);
            if (WovenProxy.class.isAssignableFrom(classToProxy)) {
                if (this.isConcrete(classToProxy) && this.implementsAll(classToProxy, interfaces)) {
                    try {
                        Constructor<?> c = classToProxy.getDeclaredConstructor(Callable.class, InvocationListener.class);
                        c.setAccessible(true);
                        proxyObject = c.newInstance(dispatcher, listener);
                    }
                    catch (Exception e) {}
                } else {
                    if ((classToProxy.getModifiers() & 0x10) != 0) {
                        throw new UnableToProxyException(classToProxy, "The class " + classToProxy + " does not implement all of the interfaces " + interfaces + " and is final. This means that we cannot create a proxy for both the class and all of the requested interfaces.");
                    }
                    proxyObject = InterfaceProxyGenerator.getProxyInstance(clientBundle, classToProxy, interfaces, dispatcher, listener);
                }
            }
            if (proxyObject == null) {
                ClassLoader classLoader = classToProxy.getClassLoader();
                if (classLoader == null) {
                    classLoader = bootClassLoader;
                }
                boolean allVisible = true;
                for (Class<?> clazz : classes) {
                    try {
                        if (classLoader.loadClass(clazz.getName()) == clazz) continue;
                        throw new UnableToProxyException(classToProxy, "The requested class " + clazz + " is different from the one seen by by " + classToProxy);
                    }
                    catch (ClassNotFoundException e) {
                        allVisible = false;
                        break;
                    }
                }
                if (!allVisible) {
                    ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
                    for (Class<?> clazz : classes) {
                        ClassLoader cl = clazz.getClassLoader();
                        if (cl == null || classLoaders.contains(cl)) continue;
                        classLoaders.add(cl);
                    }
                    classLoader = new MultiClassLoader(classLoaders);
                }
                proxyObject = ProxySubclassGenerator.newProxySubclassInstance(classToProxy, classLoader, new ProxyHandler(this, dispatcher, listener));
            }
        }
        return proxyObject;
    }

    private Class<?> getLowestSubclass(Set<Class<?>> notInterfaces) throws UnableToProxyException {
        Iterator<Class<?>> it = notInterfaces.iterator();
        Class<?> classToProxy = it.next();
        while (it.hasNext()) {
            Class<?> potential = it.next();
            if (classToProxy.isAssignableFrom(potential)) {
                classToProxy = potential;
                continue;
            }
            if (potential.isAssignableFrom(classToProxy)) continue;
            throw new UnableToProxyException(classToProxy, "The requested classes " + classToProxy + " and " + potential + " are not in the same type hierarchy");
        }
        return classToProxy;
    }

    private boolean isConcrete(Class<?> classToProxy) {
        return (classToProxy.getModifiers() & 0x400) == 0;
    }

    private boolean implementsAll(Class<?> classToProxy, Set<Class<?>> interfaces) {
        for (Class<?> iface : interfaces) {
            if (iface.isAssignableFrom(classToProxy)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isProxyClass(Class<?> clazz) {
        return WovenProxy.class.isAssignableFrom(clazz) || ProxySubclassGenerator.isProxySubclass(clazz) || Proxy.isProxyClass(clazz);
    }

    @Override
    protected InvocationHandler getInvocationHandler(Object proxy) {
        Class<?> type = proxy.getClass();
        InvocationHandler ih = null;
        if (ProxySubclassGenerator.isProxySubclass(type)) {
            ih = ProxySubclassGenerator.getInvocationHandler(proxy);
        } else if (Proxy.isProxyClass(type)) {
            ih = Proxy.getInvocationHandler(proxy);
        }
        return ih;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiClassLoader
    extends ClassLoader {
        private final List<ClassLoader> parents;

        private MultiClassLoader(List<ClassLoader> parents) {
            this.parents = parents;
        }

        @Override
        public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            for (ClassLoader cl : this.parents) {
                try {
                    return cl.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                }
            }
            throw new ClassNotFoundException(name);
        }

        @Override
        public URL getResource(String name) {
            for (ClassLoader cl : this.parents) {
                URL url = cl.getResource(name);
                if (url == null) continue;
                return url;
            }
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            final ArrayList<Enumeration<URL>> tmp = new ArrayList<Enumeration<URL>>();
            for (ClassLoader cl : this.parents) {
                tmp.add(cl.getResources(name));
            }
            return new Enumeration<URL>(){
                int index = 0;

                @Override
                public boolean hasMoreElements() {
                    return this.next();
                }

                @Override
                public URL nextElement() {
                    if (!this.next()) {
                        throw new NoSuchElementException();
                    }
                    return (URL)((Enumeration)tmp.get(this.index)).nextElement();
                }

                private boolean next() {
                    while (this.index < tmp.size()) {
                        if (tmp.get(this.index) != null && ((Enumeration)tmp.get(this.index)).hasMoreElements()) {
                            return true;
                        }
                        ++this.index;
                    }
                    return false;
                }
            };
        }
    }
}

