/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.nativefs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.sshd.common.file.FileSystemView;
import org.apache.sshd.common.file.SshFile;
import org.apache.sshd.common.file.nativefs.NativeSshFile;
import org.apache.sshd.common.file.nativefs.NativeSshFileNio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeFileSystemView
implements FileSystemView {
    private final Logger LOG = LoggerFactory.getLogger(NativeFileSystemView.class);
    private Map<String, String> roots;
    private String current;
    private String userName;
    private char separator;
    private boolean caseInsensitive = false;
    private UnsupportedAttributePolicy unsupportedAttributePolicy = UnsupportedAttributePolicy.Warn;
    static boolean isJava7;
    static boolean isWindows;

    public NativeFileSystemView(String userName) {
        this(userName, false);
    }

    public NativeFileSystemView(String userName, boolean caseInsensitive) {
        this(userName, NativeFileSystemView.getAllRoots(), System.getProperty("user.dir"), File.separatorChar, caseInsensitive);
    }

    public NativeFileSystemView(String userName, Map<String, String> roots, String current) {
        this(userName, roots, current, File.separatorChar, false);
    }

    public NativeFileSystemView(String userName, Map<String, String> roots, String current, char separator, boolean caseInsensitive) {
        if (userName == null) {
            throw new IllegalArgumentException("user can not be null");
        }
        LinkedHashMap<String, String> verRoots = new LinkedHashMap<String, String>();
        for (String r : roots.keySet()) {
            String virtual = this.appendSlash(NativeSshFile.normalizeSeparateChar(r));
            String physical = this.appendSlash(NativeSshFile.normalizeSeparateChar(roots.get(r)));
            verRoots.put(virtual, physical);
        }
        current = this.appendSlash(NativeSshFile.normalizeSeparateChar(current));
        String root = null;
        for (String r : verRoots.keySet()) {
            if (!current.startsWith(r)) continue;
            root = r;
            break;
        }
        if (root == null) {
            throw new IllegalArgumentException("Current dir " + current + " does not start from a known root: " + new ArrayList(verRoots.keySet()));
        }
        this.separator = separator;
        this.caseInsensitive = caseInsensitive;
        this.roots = verRoots;
        this.current = current;
        this.userName = userName;
        this.LOG.debug("Native filesystem view created for user \"{}\" with current dir \"{}\"", (Object)userName, (Object)this.current);
    }

    private String appendSlash(String path) {
        return path.endsWith("/") ? path : path + "/";
    }

    private static Map<String, String> getAllRoots() {
        LinkedHashMap<String, String> roots = new LinkedHashMap<String, String>();
        if (isWindows) {
            for (File file : File.listRoots()) {
                if (!file.exists()) continue;
                String root = file.toString();
                String name = root.substring(0, root.length() - 1);
                roots.put(name, root);
            }
        } else {
            roots.put("/", "/");
        }
        return roots;
    }

    public UnsupportedAttributePolicy getUnsupportedAttributePolicy() {
        return this.unsupportedAttributePolicy;
    }

    public void setUnsupportedAttributePolicy(UnsupportedAttributePolicy unsupportedAttributePolicy) {
        this.unsupportedAttributePolicy = unsupportedAttributePolicy;
    }

    public String getUserName() {
        return this.userName;
    }

    public char getSeparator() {
        return this.separator;
    }

    @Override
    public SshFile getFile(String file) {
        return this.getFile(this.current, file);
    }

    @Override
    public SshFile getFile(SshFile baseDir, String file) {
        return this.getFile(baseDir.getAbsolutePath(), file);
    }

    protected SshFile getFile(String dir, String file) {
        dir = this.appendSlash(NativeSshFile.normalizeSeparateChar(dir));
        file = NativeSshFile.normalizeSeparateChar(file);
        String root = null;
        if (this.roots.size() > 1 && file.startsWith("/")) {
            file = file.substring(1);
        }
        for (String r : this.roots.keySet()) {
            if (!file.isEmpty() && r.equals(file + "/")) {
                file = file + "/";
            }
            if (!file.startsWith(r)) continue;
            root = r;
            file = "/" + file.substring(r.length());
            break;
        }
        if (root == null) {
            file = dir + file;
            for (String r : this.roots.keySet()) {
                if (!file.startsWith(r)) continue;
                root = r;
                file = "/" + file.substring(r.length());
                break;
            }
        }
        if (root == null) {
            throw new IllegalStateException("Could not find root dir for file(" + dir + ", " + file + ")");
        }
        String physicalRoot = this.roots.get(root);
        String physicalName = NativeSshFile.getPhysicalName(physicalRoot, "/", file, this.caseInsensitive);
        File fileObj = new File(physicalName);
        String userFileName = root + physicalName.substring(physicalRoot.length());
        return this.createNativeSshFile(userFileName, fileObj, this.userName);
    }

    public NativeSshFile createNativeSshFile(String name, File file, String userName) {
        name = this.deNormalizeSeparateChar(name);
        if (isJava7) {
            return new NativeSshFileNio(this, name, file, userName);
        }
        return new NativeSshFile(this, name, file, userName);
    }

    public final String deNormalizeSeparateChar(String pathName) {
        return pathName.replace('/', this.separator);
    }

    @Override
    public FileSystemView getNormalizedView() {
        if (this.roots.size() == 1 && this.roots.containsKey("/") && this.separator == '/') {
            return this;
        }
        return new NativeFileSystemView(this.userName, this.roots, this.current, '/', this.caseInsensitive){

            public SshFile getFile(String file) {
                return this.getFile(this.reroot(NativeFileSystemView.this.current), file);
            }

            public SshFile getFile(SshFile baseDir, String file) {
                return this.getFile(baseDir.getAbsolutePath(), file);
            }

            public FileSystemView getNormalizedView() {
                return this;
            }

            protected String reroot(String file) {
                file = NativeFileSystemView.this.appendSlash(file);
                for (String r : NativeFileSystemView.this.roots.keySet()) {
                    if (!file.startsWith(r)) continue;
                    return "/" + 1.normalizeRoot(r) + file.substring(r.length());
                }
                throw new IllegalArgumentException();
            }

            protected SshFile getFile(String dir, String file) {
                String userFileName;
                dir = NativeFileSystemView.this.appendSlash(NativeSshFile.normalizeSeparateChar(dir));
                if (!(file = NativeSshFile.normalizeSeparateChar(file)).startsWith("/")) {
                    file = dir + file;
                }
                if ((userFileName = NativeSshFile.getPhysicalName("/", "/", file, NativeFileSystemView.this.caseInsensitive)).equals("/")) {
                    return new RootFile();
                }
                int idx = userFileName.indexOf("/", 1);
                if (idx < 0) {
                    String root = userFileName + "/";
                    String physRoot = null;
                    for (String r : NativeFileSystemView.this.roots.keySet()) {
                        if (!1.normalizeRoot(r).equals(root)) continue;
                        physRoot = (String)NativeFileSystemView.this.roots.get(r);
                        break;
                    }
                    if (physRoot == null) {
                        throw new IllegalArgumentException("Unknown root " + userFileName);
                    }
                    File fileObj = new File(physRoot);
                    userFileName = NativeSshFile.normalizeSeparateChar(userFileName);
                    return this.createNativeSshFile(userFileName, fileObj, NativeFileSystemView.this.userName);
                }
                String root = userFileName.substring(1, idx) + "/";
                String physRoot = null;
                for (String r : NativeFileSystemView.this.roots.keySet()) {
                    if (!1.normalizeRoot(r).equals(root)) continue;
                    physRoot = (String)NativeFileSystemView.this.roots.get(r);
                    break;
                }
                if (physRoot == null) {
                    throw new IllegalArgumentException("Unknown root " + userFileName);
                }
                File fileObj = new File(physRoot + userFileName.substring(idx + 1));
                userFileName = NativeSshFile.normalizeSeparateChar(userFileName);
                return this.createNativeSshFile(userFileName, fileObj, NativeFileSystemView.this.userName);
            }
        };
    }

    protected static String normalizeRoot(String root) {
        return root.replace(":", "");
    }

    static {
        boolean j7 = false;
        try {
            ClassLoader.getSystemClassLoader().loadClass("java.nio.file.Files");
            j7 = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        isJava7 = j7;
        boolean win = false;
        try {
            win = System.getProperty("os.name").toLowerCase().contains("win");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        isWindows = win;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RootFile
    implements SshFile {
        RootFile() {
        }

        @Override
        public String getAbsolutePath() {
            return "/";
        }

        @Override
        public String getName() {
            return "/";
        }

        @Override
        public Map<SshFile.Attribute, Object> getAttributes(boolean followLinks) throws IOException {
            return null;
        }

        @Override
        public void setAttributes(Map<SshFile.Attribute, Object> attributes) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getAttribute(SshFile.Attribute attribute, boolean followLinks) throws IOException {
            return null;
        }

        @Override
        public void setAttribute(SshFile.Attribute attribute, Object value) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readSymbolicLink() throws IOException {
            return null;
        }

        @Override
        public void createSymbolicLink(SshFile destination) throws IOException {
        }

        @Override
        public String getOwner() {
            return null;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public boolean isFile() {
            return false;
        }

        @Override
        public boolean doesExist() {
            return true;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public boolean isExecutable() {
            return false;
        }

        @Override
        public boolean isRemovable() {
            return false;
        }

        @Override
        public SshFile getParentFile() {
            return null;
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public boolean setLastModified(long time) {
            return false;
        }

        @Override
        public long getSize() {
            return 0L;
        }

        @Override
        public boolean mkdir() {
            return false;
        }

        @Override
        public boolean delete() {
            return false;
        }

        @Override
        public boolean create() throws IOException {
            return false;
        }

        @Override
        public void truncate() throws IOException {
        }

        @Override
        public boolean move(SshFile destination) {
            return false;
        }

        @Override
        public List<SshFile> listSshFiles() {
            ArrayList<SshFile> list = new ArrayList<SshFile>();
            for (String root : NativeFileSystemView.this.roots.keySet()) {
                String display = NativeFileSystemView.normalizeRoot(root);
                display = "/" + display.substring(display.length() - 1);
                list.add(NativeFileSystemView.this.createNativeSshFile(display, new File((String)NativeFileSystemView.this.roots.get(root)), NativeFileSystemView.this.userName));
            }
            return list;
        }

        @Override
        public OutputStream createOutputStream(long offset) throws IOException {
            return null;
        }

        @Override
        public InputStream createInputStream(long offset) throws IOException {
            return null;
        }

        @Override
        public void handleClose() throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UnsupportedAttributePolicy {
        Ignore,
        Warn,
        ThrowException;

    }
}

