/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management.mbeans.config.internal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.apache.karaf.management.mbeans.config.ConfigMBean;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigMBeanImpl
extends StandardMBean
implements ConfigMBean {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigMBeanImpl.class);
    private final String FELIX_FILEINSTALL_FILENAME = "felix.fileinstall.filename";
    private ConfigurationAdmin configurationAdmin;
    private List<ArtifactInstaller> artifactInstallers;
    private File storage;

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public File getStorage() {
        return this.storage;
    }

    public void setStorage(File storage) {
        this.storage = storage;
    }

    public void setArtifactInstallers(List<ArtifactInstaller> artifactInstallers) {
        this.artifactInstallers = artifactInstallers;
    }

    public ConfigMBeanImpl() throws NotCompliantMBeanException {
        super(ConfigMBean.class);
    }

    @Override
    public List<String> getConfigs() throws Exception {
        Configuration[] configurations = this.configurationAdmin.listConfigurations(null);
        ArrayList<String> pids = new ArrayList<String>();
        for (int i = 0; i < configurations.length; ++i) {
            pids.add(configurations[i].getPid());
        }
        return pids;
    }

    @Override
    public List<String> list() throws Exception {
        return this.getConfigs();
    }

    @Override
    public void create(String pid) throws Exception {
        this.store(pid, new Hashtable(), false);
    }

    @Override
    public void delete(String pid) throws Exception {
        Configuration configuration = this.configurationAdmin.getConfiguration(pid);
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration PID " + pid + " doesn't exist");
        }
        configuration.delete();
        if (this.storage != null) {
            File cfgFile = new File(this.storage, pid + ".cfg");
            cfgFile.delete();
        }
    }

    @Override
    public Map<String, String> listProperties(String pid) throws Exception {
        Configuration configuration = this.configurationAdmin.getConfiguration(pid);
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration PID " + pid + " doesn't exist");
        }
        Dictionary dictionary = configuration.getProperties();
        if (dictionary == null) {
            dictionary = new Properties();
        }
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        Enumeration e = dictionary.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = dictionary.get(key);
            propertiesMap.put(key.toString(), value.toString());
        }
        return propertiesMap;
    }

    @Override
    public Map<String, String> proplist(String pid) throws Exception {
        return this.listProperties(pid);
    }

    @Override
    public void deleteProperty(String pid, String key) throws Exception {
        Configuration configuration = this.configurationAdmin.getConfiguration(pid);
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration PID " + pid + " doesn't exist");
        }
        Dictionary dictionary = configuration.getProperties();
        if (dictionary == null) {
            dictionary = new Properties();
        }
        dictionary.remove(key);
        this.store(pid, dictionary, false);
    }

    @Override
    public void propdel(String pid, String key) throws Exception {
        this.deleteProperty(pid, key);
    }

    @Override
    public void appendProperty(String pid, String key, String value) throws Exception {
        Object currentValue;
        Configuration configuration = this.configurationAdmin.getConfiguration(pid);
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration PID " + pid + " doesn't exist");
        }
        Dictionary dictionary = configuration.getProperties();
        if (dictionary == null) {
            dictionary = new Properties();
        }
        if ((currentValue = dictionary.get(key)) == null) {
            dictionary.put(key, value);
        } else if (currentValue instanceof String) {
            dictionary.put(key, currentValue + value);
        } else {
            throw new IllegalStateException("Current value is not a String");
        }
        this.store(pid, dictionary, false);
    }

    @Override
    public void propappend(String pid, String key, String value) throws Exception {
        this.appendProperty(pid, key, value);
    }

    @Override
    public void setProperty(String pid, String key, String value) throws Exception {
        Configuration configuration = this.configurationAdmin.getConfiguration(pid);
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration PID " + pid + " doesn't exist");
        }
        Dictionary dictionary = configuration.getProperties();
        if (dictionary == null) {
            dictionary = new Properties();
        }
        dictionary.put(key, value);
        this.store(pid, dictionary, false);
    }

    @Override
    public void propset(String pid, String key, String value) throws Exception {
        this.setProperty(pid, key, value);
    }

    private void store(String pid, Dictionary properties, boolean bypassStorage) throws Exception {
        if (!bypassStorage && this.storage != null) {
            File storageFile = new File(this.storage, pid + ".cfg");
            Configuration configuration = this.configurationAdmin.getConfiguration(pid, null);
            if (configuration != null && configuration.getProperties() != null) {
                Object val = configuration.getProperties().get("felix.fileinstall.filename");
                try {
                    if (val instanceof URL) {
                        storageFile = new File(((URL)val).toURI());
                    }
                    if (val instanceof URI) {
                        storageFile = new File((URI)val);
                    }
                    if (val instanceof String) {
                        storageFile = new File(new URL((String)val).toURI());
                    }
                }
                catch (Exception e) {
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
            }
            org.apache.felix.utils.properties.Properties p = new org.apache.felix.utils.properties.Properties(storageFile);
            p.clear();
            Enumeration keys = properties.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                if ("service.pid".equals(key) || "service.factoryPid".equals(key) || "felix.fileinstall.filename".equals(key)) continue;
                p.put((String)key, (String)properties.get(key));
            }
            ArrayList<String> propertiesToRemove = new ArrayList<String>();
            for (Object k : p.keySet()) {
                if (properties.get(k) != null || "service.pid".equals(k) || "service.factoryPid".equals(k) || "felix.fileinstall.filename".equals(k)) continue;
                propertiesToRemove.add(k.toString());
            }
            for (String string : propertiesToRemove) {
                p.remove(string);
            }
            this.storage.mkdirs();
            p.save();
            this.updateFileInstall(storageFile);
        } else {
            String[] pids;
            Configuration cfg = this.configurationAdmin.getConfiguration(pid, null);
            if (cfg.getProperties() == null && (pids = this.parsePid(pid))[1] != null) {
                cfg = this.configurationAdmin.createFactoryConfiguration(pids[0], null);
            }
            if (cfg.getBundleLocation() != null) {
                cfg.setBundleLocation(null);
            }
            cfg.update(properties);
        }
    }

    private void updateFileInstall(File storageFile) {
        if (this.artifactInstallers != null) {
            for (ArtifactInstaller installer : this.artifactInstallers) {
                if (!installer.canHandle(storageFile)) continue;
                try {
                    installer.update(storageFile);
                }
                catch (Exception e) {
                    LOG.warn("Error updating config " + storageFile + " in felix fileinstall" + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private String[] parsePid(String pid) {
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }
}

