/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.util.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ops4j.util.collections.PropertyResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ElementHelper {
    private ElementHelper() {
    }

    public static Element getRootElement(InputStream input) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        try {
            factory.setFeature("http://xml.org/sax/features/namespaces", false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        DocumentBuilder builder = factory.newDocumentBuilder();
        try {
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                }
            });
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        Document document = builder.parse(input);
        return document.getDocumentElement();
    }

    public static Element getChild(Element root, String name) {
        if (null == root) {
            return null;
        }
        NodeList list = root.getElementsByTagName(name);
        int n = list.getLength();
        if (n < 1) {
            return null;
        }
        return (Element)list.item(0);
    }

    public static Element[] getChildren(Element root, String name) {
        if (null == root) {
            return new Element[0];
        }
        NodeList list = root.getElementsByTagName(name);
        int n = list.getLength();
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < n; ++i) {
            Node item = list.item(i);
            if (!(item instanceof Element)) continue;
            result.add((Element)item);
        }
        Element[] retval = new Element[result.size()];
        result.toArray(retval);
        return retval;
    }

    public static Element[] getChildren(Element root) {
        if (null == root) {
            return new Element[0];
        }
        NodeList list = root.getChildNodes();
        int n = list.getLength();
        if (n < 1) {
            return new Element[0];
        }
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < n; ++i) {
            Node item = list.item(i);
            if (!(item instanceof Element)) continue;
            result.add((Element)item);
        }
        Element[] retval = new Element[result.size()];
        result.toArray(retval);
        return retval;
    }

    public static String getValue(Element node) {
        if (null == node) {
            return null;
        }
        String value = node.getChildNodes().getLength() > 0 ? node.getFirstChild().getNodeValue() : node.getNodeValue();
        return ElementHelper.normalize(value);
    }

    public static String getAttribute(Element node, String key) {
        return ElementHelper.getAttribute(node, key, null);
    }

    public static String getAttribute(Element node, String key, String def) {
        if (null == node) {
            return def;
        }
        String value = node.getAttribute(key);
        if (null == value) {
            return def;
        }
        if ("".equals(value)) {
            return def;
        }
        return ElementHelper.normalize(value);
    }

    private static String normalize(String value) {
        return ElementHelper.normalize(value, System.getProperties());
    }

    private static String normalize(String value, Properties props) {
        return PropertyResolver.resolve((Properties)props, (String)value);
    }
}

