/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.util.collections;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ops4j.lang.NullArgumentException;

public class PropertiesWriter {
    private static final String DEFAULT_SEPARATOR = ",";
    private final OutputStream m_outputStream;
    private List<String> m_content;
    private Map<String, Integer> m_positions;
    private Map<String, List<String>> m_values;
    private String m_separator;

    public PropertiesWriter(OutputStream outputStream) {
        this(outputStream, DEFAULT_SEPARATOR);
    }

    public PropertiesWriter(OutputStream outputStream, String separator) {
        NullArgumentException.validateNotNull((Object)outputStream, (String)"Output stream");
        NullArgumentException.validateNotNull((Object)separator, (String)"Separator");
        this.m_outputStream = outputStream;
        this.m_separator = separator;
        this.m_content = new ArrayList<String>();
        this.m_positions = new HashMap<String, Integer>();
        this.m_values = new HashMap<String, List<String>>();
    }

    public PropertiesWriter append(String key, String value) {
        NullArgumentException.validateNotEmpty((String)key, (String)"Key");
        String valueToAdd = value;
        if (value == null) {
            valueToAdd = "";
        }
        Integer position = this.m_positions.get(key);
        List<String> values = this.m_values.get(key);
        if (values == null) {
            values = new ArrayList<String>();
            this.m_values.put(key, values);
        }
        values.add(valueToAdd);
        StringBuilder builder = new StringBuilder().append(key).append("=");
        if (values.size() == 1) {
            builder.append(valueToAdd);
        } else {
            builder.append("\\\n");
            String trail = null;
            for (String storedValue : values) {
                if (trail != null) {
                    builder.append(trail);
                }
                builder.append(storedValue);
                trail = this.m_separator + "\\\n";
            }
        }
        if (position == null) {
            this.m_content.add(builder.toString());
            this.m_positions.put(key, this.m_content.size() - 1);
        } else {
            this.m_content.set(position, builder.toString());
        }
        return this;
    }

    public PropertiesWriter append(String comment) {
        String commentToAdd = "#" + comment;
        if (comment == null) {
            commentToAdd = "#";
        }
        this.m_content.add(commentToAdd);
        return this;
    }

    public PropertiesWriter append() {
        this.m_content.add("");
        return this;
    }

    public PropertiesWriter appendRaw(String value) {
        if (value != null) {
            this.m_content.add(value);
        }
        return this;
    }

    public void write() throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.m_outputStream));
        for (String line : this.m_content) {
            writer.write(line);
            writer.newLine();
        }
        writer.flush();
        writer.close();
    }
}

