/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Command(scope="shell", name="wc", description="Print newline, word, and byte counts for each file.")
public class WcAction
extends AbstractAction {
    @Option(name="-l", aliases={"--lines"}, description="Print the newline counts.", required=false, multiValued=false)
    private boolean lines;
    @Option(name="-w", aliases={"--words"}, description="Print the word counts.", required=false, multiValued=false)
    private boolean words;
    @Option(name="-m", aliases={"--chars"}, description="Print the character counts.", required=false, multiValued=false)
    private boolean chars;
    @Option(name="-c", aliases={"--bytes"}, description="Print the byte counts.", required=false, multiValued=false)
    private boolean bytes;
    @Argument(index=0, name="files", description="The list of files where to perform the count", required=false, multiValued=true)
    private List<File> files;

    protected Object doExecute() throws Exception {
        String resultString;
        this.setDefaultOptions();
        if (this.files == null) {
            WordCounts wordCounts = this.getWordCounts(System.in);
            resultString = this.formatWordCounts(wordCounts, null);
        } else {
            resultString = this.getFilesWordCount(this.files);
        }
        System.out.println(resultString);
        return null;
    }

    protected void setDefaultOptions() {
        boolean noOptionSupplied;
        boolean bl = noOptionSupplied = !this.bytes && !this.chars && !this.lines && !this.words;
        if (noOptionSupplied) {
            this.lines = true;
            this.words = true;
            this.bytes = true;
        }
    }

    protected String getFilesWordCount(List<File> files) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        WordCounts totalWordCounts = new WordCounts();
        for (File file : files) {
            WordCounts fileWordCount = this.getWordCounts(new FileInputStream(file));
            String fileResultString = this.formatWordCounts(fileWordCount, file.getName());
            totalWordCounts = totalWordCounts.add(fileWordCount);
            stringBuilder.append(fileResultString).append('\n');
        }
        if (files.size() > 1) {
            stringBuilder.append(this.formatWordCounts(totalWordCounts, "total"));
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WordCounts getWordCounts(InputStream inputStream) throws IOException {
        WordCounts wordCounts = new WordCounts();
        BufferedReader bufferedReader = null;
        try {
            int current;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            boolean skipNextLineFeed = false;
            boolean previousWhitespace = true;
            while ((current = bufferedReader.read()) != -1) {
                boolean isCurrentWhitespace;
                boolean eol;
                ++wordCounts.byteCount;
                ++wordCounts.charCount;
                boolean isSkipNewLineFeed = skipNextLineFeed && current == 10;
                skipNextLineFeed = false;
                if (isSkipNewLineFeed) continue;
                boolean bl = eol = current == 10 || current == 13;
                if (eol) {
                    ++wordCounts.lineCount;
                    if (current == 13) {
                        skipNextLineFeed = true;
                    }
                }
                if (!(isCurrentWhitespace = Character.isWhitespace(current)) && previousWhitespace) {
                    ++wordCounts.wordCount;
                }
                previousWhitespace = isCurrentWhitespace;
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return wordCounts;
    }

    protected String formatWordCounts(WordCounts wordCounts, String reportName) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.lines) {
            stringBuilder.append('\t').append(wordCounts.lineCount);
        }
        if (this.words) {
            stringBuilder.append('\t').append(wordCounts.wordCount);
        }
        if (this.chars) {
            stringBuilder.append('\t').append(wordCounts.charCount);
        }
        if (this.bytes) {
            stringBuilder.append('\t').append(wordCounts.byteCount);
        }
        if (reportName != null) {
            stringBuilder.append('\t').append(reportName);
        }
        return stringBuilder.toString();
    }

    protected static class WordCounts {
        protected int lineCount;
        protected int wordCount;
        protected int byteCount;
        protected int charCount;

        protected WordCounts() {
        }

        public WordCounts add(WordCounts append) {
            WordCounts result = new WordCounts();
            result.lineCount = this.lineCount + append.lineCount;
            result.wordCount = this.wordCount + append.wordCount;
            result.byteCount = this.byteCount + append.byteCount;
            result.charCount = this.charCount + append.charCount;
            return result;
        }
    }
}

