/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.diagnostic.core.internal;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.karaf.diagnostic.core.Dump;
import org.apache.karaf.diagnostic.core.common.ZipDumpDestination;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class Activator
implements BundleActivator,
SignalHandler {
    private static final String SIGNAL = "HUP";
    private BundleContext bundleContext;
    private SignalHandler previous;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        if (!this.isWindows()) {
            this.previous = Signal.handle(new Signal(SIGNAL), this);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (!this.isWindows()) {
            Signal.handle(new Signal(SIGNAL), this.previous);
        }
    }

    public void handle(Signal signal) {
        SimpleDateFormat dumpFormat = new SimpleDateFormat("yyyy-MM-dd_HHmmss-SSS");
        String fileName = "dump-" + dumpFormat.format(new Date()) + ".zip";
        ZipDumpDestination destination = new ZipDumpDestination(new File(fileName));
        Dump.dump(this.bundleContext, destination);
    }

    private boolean isWindows() {
        String os = System.getProperty("os.name", "Unknown");
        return os.startsWith("Win");
    }
}

