/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.ldap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.config.KeystoreManager;
import org.apache.karaf.jaas.modules.AbstractKarafLoginModule;
import org.apache.karaf.jaas.modules.ldap.LDAPCache;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPLoginModule
extends AbstractKarafLoginModule {
    private static final String DEFAULT_AUTHENTICATION = "simple";
    private static Logger logger = LoggerFactory.getLogger(LDAPLoginModule.class);
    public static final String CONNECTION_URL = "connection.url";
    public static final String CONNECTION_USERNAME = "connection.username";
    public static final String CONNECTION_PASSWORD = "connection.password";
    public static final String USER_BASE_DN = "user.base.dn";
    public static final String USER_FILTER = "user.filter";
    public static final String USER_SEARCH_SUBTREE = "user.search.subtree";
    public static final String ROLE_BASE_DN = "role.base.dn";
    public static final String ROLE_FILTER = "role.filter";
    public static final String ROLE_NAME_ATTRIBUTE = "role.name.attribute";
    public static final String ROLE_SEARCH_SUBTREE = "role.search.subtree";
    public static final String ROLE_MAPPING = "role.mapping";
    public static final String AUTHENTICATION = "authentication";
    public static final String ALLOW_EMPTY_PASSWORDS = "allowEmptyPasswords";
    public static final String INITIAL_CONTEXT_FACTORY = "initial.context.factory";
    public static final String CONTEXT_PREFIX = "context.";
    public static final String SSL = "ssl";
    public static final String SSL_PROVIDER = "ssl.provider";
    public static final String SSL_PROTOCOL = "ssl.protocol";
    public static final String SSL_ALGORITHM = "ssl.algorithm";
    public static final String SSL_KEYSTORE = "ssl.keystore";
    public static final String SSL_KEYALIAS = "ssl.keyalias";
    public static final String SSL_TRUSTSTORE = "ssl.truststore";
    public static final String SSL_TIMEOUT = "ssl.timeout";
    public static final String DEFAULT_INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private String connectionURL;
    private String connectionUsername;
    private String connectionPassword;
    private String userBaseDN;
    private String userFilter;
    private boolean userSearchSubtree = true;
    private String roleBaseDN;
    private String roleFilter;
    private String roleNameAttribute;
    private boolean roleSearchSubtree = true;
    private Map<String, Set<String>> roleMapping;
    private String authentication = "simple";
    private boolean allowEmptyPasswords = false;
    private String initialContextFactory = null;
    private boolean ssl;
    private String sslProvider;
    private String sslProtocol;
    private String sslAlgorithm;
    private String sslKeystore;
    private String sslKeyAlias;
    private String sslTrustStore;
    private int sslTimeout = 10;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, options);
        this.connectionURL = (String)options.get(CONNECTION_URL);
        this.connectionUsername = (String)options.get(CONNECTION_USERNAME);
        this.connectionPassword = (String)options.get(CONNECTION_PASSWORD);
        this.userBaseDN = (String)options.get(USER_BASE_DN);
        this.userFilter = (String)options.get(USER_FILTER);
        this.userSearchSubtree = Boolean.parseBoolean((String)options.get(USER_SEARCH_SUBTREE));
        this.roleMapping = this.parseRoleMapping((String)options.get(ROLE_MAPPING));
        this.roleBaseDN = (String)options.get(ROLE_BASE_DN);
        this.roleFilter = (String)options.get(ROLE_FILTER);
        this.roleNameAttribute = (String)options.get(ROLE_NAME_ATTRIBUTE);
        this.roleSearchSubtree = Boolean.parseBoolean((String)options.get(ROLE_SEARCH_SUBTREE));
        this.initialContextFactory = (String)options.get(INITIAL_CONTEXT_FACTORY);
        if (this.initialContextFactory == null) {
            this.initialContextFactory = DEFAULT_INITIAL_CONTEXT_FACTORY;
        }
        this.authentication = (String)options.get(AUTHENTICATION);
        if (this.authentication == null) {
            this.authentication = DEFAULT_AUTHENTICATION;
        }
        this.allowEmptyPasswords = Boolean.parseBoolean((String)options.get(ALLOW_EMPTY_PASSWORDS));
        if (this.connectionURL == null || this.connectionURL.trim().length() == 0) {
            logger.error("No LDAP URL specified.");
        } else if (!this.connectionURL.startsWith("ldap:") && !this.connectionURL.startsWith("ldaps:")) {
            logger.error("Invalid LDAP URL: " + this.connectionURL);
        }
        this.ssl = options.get(SSL) != null ? Boolean.parseBoolean((String)options.get(SSL)) : this.connectionURL.startsWith("ldaps:");
        this.sslProvider = (String)options.get(SSL_PROVIDER);
        this.sslProtocol = (String)options.get(SSL_PROTOCOL);
        this.sslAlgorithm = (String)options.get(SSL_ALGORITHM);
        this.sslKeystore = (String)options.get(SSL_KEYSTORE);
        this.sslKeyAlias = (String)options.get(SSL_KEYALIAS);
        this.sslTrustStore = (String)options.get(SSL_TRUSTSTORE);
        if (options.get(SSL_TIMEOUT) != null) {
            this.sslTimeout = (Integer)options.get(SSL_TIMEOUT);
        }
    }

    private Map<String, Set<String>> parseRoleMapping(String option) {
        HashMap<String, Set<String>> roleMapping = new HashMap<String, Set<String>>();
        if (option != null) {
            String[] mappings;
            logger.debug("Parse role mapping {}", (Object)option);
            for (String mapping : mappings = option.split(";")) {
                String[] map = mapping.split("=", 2);
                String ldapRole = map[0].trim();
                String[] karafRoles = map[1].split(",");
                if (roleMapping.get(ldapRole) == null) {
                    roleMapping.put(ldapRole, new HashSet());
                }
                Set karafRolesSet = (Set)roleMapping.get(ldapRole);
                for (String karafRole : karafRoles) {
                    karafRolesSet.add(karafRole.trim());
                }
            }
        }
        return roleMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean login() throws LoginException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            boolean bl = this.doLogin();
            return bl;
        }
        finally {
            ManagedSSLSocketFactory.setSocketFactory(null);
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doLogin() throws LoginException {
        String userDNNamespace;
        String userDN;
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioException) {
            throw new LoginException(ioException.getMessage());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new LoginException(unsupportedCallbackException.getMessage() + " not available to obtain information from user.");
        }
        this.user = ((NameCallback)callbacks[0]).getName();
        char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
        if ("none".equals(this.authentication) && (this.user != null || tmpPassword != null)) {
            logger.debug("Changing from authentication = none to simple since user or password was specified.");
            this.authentication = DEFAULT_AUTHENTICATION;
        }
        if (!("none".equals(this.authentication) || this.allowEmptyPasswords || tmpPassword != null && tmpPassword.length != 0)) {
            throw new LoginException("Empty passwords not allowed");
        }
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        String password = new String(tmpPassword);
        this.principals = new HashSet();
        final Hashtable env = new Hashtable();
        logger.debug("Create the LDAP initial context.");
        for (String key : this.options.keySet()) {
            if (!key.startsWith(CONTEXT_PREFIX)) continue;
            env.put(key.substring(CONTEXT_PREFIX.length()), this.options.get(key));
        }
        env.put("java.naming.factory.initial", this.initialContextFactory);
        env.put("java.naming.provider.url", this.connectionURL);
        if (this.connectionUsername != null && this.connectionUsername.trim().length() > 0) {
            logger.debug("Bound access requested.");
            env.put("java.naming.security.authentication", this.authentication);
            env.put("java.naming.security.principal", this.connectionUsername);
            env.put("java.naming.security.credentials", this.connectionPassword);
        }
        if (this.ssl) {
            this.setupSsl(env);
        }
        logger.debug("Get the user DN.");
        try {
            String[] userDnAndNamespace = LDAPCache.getCache(env).getUserDnAndNamespace(this.user, new Callable<String[]>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public String[] call() throws Exception {
                    InitialDirContext context = null;
                    NamingEnumeration<SearchResult> namingEnumeration = null;
                    logger.debug("Initialize the JNDI LDAP Dir Context.");
                    context = new InitialDirContext(env);
                    logger.debug("Define the subtree scope search control.");
                    SearchControls controls = new SearchControls();
                    if (LDAPLoginModule.this.userSearchSubtree) {
                        controls.setSearchScope(2);
                    } else {
                        controls.setSearchScope(1);
                    }
                    logger.debug("Looking for the user in LDAP with ");
                    logger.debug("  base DN: " + LDAPLoginModule.this.userBaseDN);
                    LDAPLoginModule.this.userFilter = LDAPLoginModule.this.userFilter.replaceAll(Pattern.quote("%u"), Matcher.quoteReplacement(LDAPLoginModule.this.user));
                    LDAPLoginModule.this.userFilter = LDAPLoginModule.this.userFilter.replace("\\", "\\\\");
                    logger.debug("  filter: " + LDAPLoginModule.this.userFilter);
                    namingEnumeration = context.search(LDAPLoginModule.this.userBaseDN, LDAPLoginModule.this.userFilter, controls);
                    if (!namingEnumeration.hasMore()) {
                        logger.warn("User " + LDAPLoginModule.this.user + " not found in LDAP.");
                        String[] stringArray = null;
                        return stringArray;
                    }
                    logger.debug("Get the user DN.");
                    SearchResult result = namingEnumeration.next();
                    String userDNNamespace = result.getNameInNamespace();
                    int indexOfUserBaseDN = userDNNamespace.toLowerCase().indexOf("," + LDAPLoginModule.this.userBaseDN.toLowerCase());
                    String userDN = indexOfUserBaseDN > 0 ? userDNNamespace.substring(0, indexOfUserBaseDN) : result.getName();
                    String[] stringArray = new String[]{userDN, userDNNamespace};
                    return stringArray;
                    finally {
                        if (namingEnumeration != null) {
                            try {
                                namingEnumeration.close();
                            }
                            catch (Exception e) {}
                        }
                        if (context != null) {
                            try {
                                context.close();
                            }
                            catch (Exception e) {}
                        }
                    }
                }
            });
            if (userDnAndNamespace == null) {
                return false;
            }
            userDN = userDnAndNamespace[0];
            userDNNamespace = userDnAndNamespace[1];
        }
        catch (Exception e) {
            logger.warn("Can't connect to the LDAP server: {}", (Object)e.getMessage(), (Object)e);
            throw new LoginException("Can't connect to the LDAP server: " + e.getMessage());
        }
        Context context = null;
        try {
            logger.debug("Bind user (authentication).");
            env.put("java.naming.security.authentication", this.authentication);
            logger.debug("Set the security principal for " + userDN + "," + this.userBaseDN);
            env.put("java.naming.security.principal", userDN + "," + this.userBaseDN);
            env.put("java.naming.security.credentials", password);
            logger.debug("Binding the user.");
            context = new InitialDirContext(env);
            logger.debug("User " + this.user + " successfully bound.");
            context.close();
        }
        catch (Exception e) {
            logger.warn("User " + this.user + " authentication failed.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (Exception e) {}
            }
        }
        this.principals.add(new UserPrincipal(this.user));
        try {
            String[] roles;
            for (String role : roles = LDAPCache.getCache(env).getUserRoles(userDN, new Callable<String[]>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public String[] call() throws Exception {
                    Context context = null;
                    try {
                        logger.debug("Get user roles.");
                        if (LDAPLoginModule.this.connectionUsername != null && LDAPLoginModule.this.connectionUsername.trim().length() > 0) {
                            env.put("java.naming.security.authentication", LDAPLoginModule.this.authentication);
                            env.put("java.naming.security.principal", LDAPLoginModule.this.connectionUsername);
                            env.put("java.naming.security.credentials", LDAPLoginModule.this.connectionPassword);
                        }
                        context = new InitialDirContext(env);
                        SearchControls controls = new SearchControls();
                        if (LDAPLoginModule.this.roleSearchSubtree) {
                            controls.setSearchScope(2);
                        } else {
                            controls.setSearchScope(1);
                        }
                        if (LDAPLoginModule.this.roleNameAttribute != null) {
                            controls.setReturningAttributes(new String[]{LDAPLoginModule.this.roleNameAttribute});
                        }
                        logger.debug("Looking for the user roles in LDAP with ");
                        logger.debug("  base DN: " + LDAPLoginModule.this.roleBaseDN);
                        LDAPLoginModule.this.roleFilter = LDAPLoginModule.this.roleFilter.replaceAll(Pattern.quote("%u"), Matcher.quoteReplacement(LDAPLoginModule.this.user));
                        LDAPLoginModule.this.roleFilter = LDAPLoginModule.this.roleFilter.replaceAll(Pattern.quote("%dn"), Matcher.quoteReplacement(userDN));
                        LDAPLoginModule.this.roleFilter = LDAPLoginModule.this.roleFilter.replaceAll(Pattern.quote("%fqdn"), Matcher.quoteReplacement(userDNNamespace));
                        LDAPLoginModule.this.roleFilter = LDAPLoginModule.this.roleFilter.replace("\\", "\\\\");
                        logger.debug("  filter: " + LDAPLoginModule.this.roleFilter);
                        ArrayList<String> rolesList = new ArrayList<String>();
                        NamingEnumeration<SearchResult> namingEnumeration = context.search(LDAPLoginModule.this.roleBaseDN, LDAPLoginModule.this.roleFilter, controls);
                        while (namingEnumeration.hasMore()) {
                            SearchResult result = namingEnumeration.next();
                            Attributes attributes = result.getAttributes();
                            Attribute roles = attributes.get(LDAPLoginModule.this.roleNameAttribute);
                            if (roles == null) continue;
                            for (int i = 0; i < roles.size(); ++i) {
                                String role = (String)roles.get(i);
                                if (role == null) continue;
                                logger.debug("User {} is a member of role {}", (Object)LDAPLoginModule.this.user, (Object)role);
                                Set<String> mapped = LDAPLoginModule.this.tryMappingRole(role);
                                if (mapped.isEmpty()) {
                                    rolesList.add(role);
                                    continue;
                                }
                                for (String r : mapped) {
                                    rolesList.add(r);
                                }
                            }
                        }
                        String[] stringArray = rolesList.toArray(new String[rolesList.size()]);
                        return stringArray;
                    }
                    finally {
                        if (context != null) {
                            try {
                                context.close();
                            }
                            catch (Exception e) {}
                        }
                    }
                }
            })) {
                this.principals.add(new RolePrincipal(role));
            }
        }
        catch (Exception e) {
            throw new LoginException("Can't get user " + this.user + " roles: " + e.getMessage());
        }
        return true;
    }

    protected Set<String> tryMappingRole(String role) {
        HashSet<String> roles = new HashSet<String>();
        if (this.roleMapping == null || this.roleMapping.isEmpty()) {
            return roles;
        }
        Set<String> karafRoles = this.roleMapping.get(role);
        if (karafRoles != null) {
            for (String karafRole : karafRoles) {
                logger.debug("LDAP role {} is mapped to Karaf role {}", (Object)role, (Object)karafRole);
                roles.add(karafRole);
            }
        }
        return roles;
    }

    protected void setupSsl(Hashtable env) throws LoginException {
        ServiceReference ref = null;
        try {
            logger.debug("Setting up SSL");
            env.put("java.naming.security.protocol", SSL);
            env.put("java.naming.ldap.factory.socket", ManagedSSLSocketFactory.class.getName());
            ref = this.bundleContext.getServiceReference(KeystoreManager.class.getName());
            KeystoreManager manager = (KeystoreManager)this.bundleContext.getService(ref);
            SSLSocketFactory factory = manager.createSSLFactory(this.sslProvider, this.sslProtocol, this.sslAlgorithm, this.sslKeystore, this.sslKeyAlias, this.sslTrustStore, (long)this.sslTimeout);
            ManagedSSLSocketFactory.setSocketFactory(factory);
            Thread.currentThread().setContextClassLoader(ManagedSSLSocketFactory.class.getClassLoader());
        }
        catch (Exception e) {
            try {
                throw new LoginException("Unable to setup SSL support for LDAP: " + e.getMessage());
            }
            catch (Throwable throwable) {
                this.bundleContext.ungetService(ref);
                throw throwable;
            }
        }
        this.bundleContext.ungetService(ref);
    }

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        return true;
    }

    public static abstract class ManagedSSLSocketFactory
    extends SSLSocketFactory {
        private static final ThreadLocal<SSLSocketFactory> factories = new ThreadLocal();

        public static void setSocketFactory(SSLSocketFactory factory) {
            factories.set(factory);
        }

        public static SSLSocketFactory getDefault() {
            SSLSocketFactory factory = factories.get();
            if (factory == null) {
                throw new IllegalStateException("No SSLSocketFactory parameters have been set!");
            }
            return factory;
        }
    }
}

