/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.osgi;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import jline.console.ConsoleReader;
import org.apache.felix.service.command.CommandSession;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.startlevel.StartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger LOGGER = LoggerFactory.getLogger(Util.class);

    public static String getBundleName(Bundle bundle) {
        if (bundle != null) {
            String name = (String)bundle.getHeaders().get("Bundle-Name");
            return name == null ? "Bundle " + Long.toString(bundle.getBundleId()) : name + " (" + Long.toString(bundle.getBundleId()) + ")";
        }
        return "[STALE BUNDLE]";
    }

    public static String getUnderlineString(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            sb.append('-');
        }
        return sb.toString();
    }

    public static String getValueString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof Collection) {
            Object[] array = ((Collection)obj).toArray();
            return Util.getValueString(array);
        }
        if (obj.getClass().isArray()) {
            Object[] array = (Object[])obj;
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int i = 0; i < array.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(Util.getValueString(array[i]));
            }
            sb.append("]");
            return sb.toString();
        }
        return obj.toString();
    }

    public static boolean isASystemBundle(BundleContext bundleContext, Bundle bundle) {
        StartLevel sl;
        ServiceReference ref = bundleContext.getServiceReference(StartLevel.class.getName());
        if (ref != null && (sl = (StartLevel)bundleContext.getService(ref)) != null) {
            int level = sl.getBundleStartLevel(bundle);
            int sbsl = 49;
            String sbslProp = bundleContext.getProperty("karaf.systemBundlesStartLevel");
            if (sbslProp != null) {
                try {
                    sbsl = Integer.valueOf(sbslProp);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return level <= sbsl;
        }
        return false;
    }

    public static boolean accessToSystemBundleIsAllowed(long bundleId, CommandSession session) throws IOException {
        String str;
        do {
            String msg;
            ConsoleReader reader;
            if (!"yes".equalsIgnoreCase(str = (reader = (ConsoleReader)session.get(".jline.reader")).readLine(msg = "You are about to access system bundle " + bundleId + ".  Do you wish to continue (yes/no): "))) continue;
            return true;
        } while (!"no".equalsIgnoreCase(str));
        return false;
    }
}

