/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.config.completers;

import java.io.IOException;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.ArgumentCompleter;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.apache.karaf.shell.console.jline.CommandSessionHolder;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationPropertyCompleter
implements Completer {
    private final StringsCompleter delegate = new StringsCompleter();
    private static final String OPTION = "-p";
    private static final String ALIAS = "--pid";
    private ConfigurationAdmin configAdmin;

    public int complete(String buffer, int cursor, List candidates) {
        CommandSession session = CommandSessionHolder.getSession();
        if (session != null) {
            String pid = this.getPid(session);
            Set<String> propertyNames = this.getPropertyNames(pid);
            this.delegate.getStrings().clear();
            if (propertyNames != null && !propertyNames.isEmpty()) {
                this.delegate.getStrings().addAll(propertyNames);
            }
        }
        return this.delegate.complete(buffer, cursor, candidates);
    }

    private String getPid(CommandSession commandSession) {
        String pid = (String)commandSession.get("ConfigCommand.PID");
        ArgumentCompleter.ArgumentList list = (ArgumentCompleter.ArgumentList)commandSession.get("ARGUMENTS_LIST");
        if (list != null && list.getArguments() != null && list.getArguments().length > 0) {
            int index;
            List<String> arguments = Arrays.asList(list.getArguments());
            if (arguments.contains(OPTION)) {
                index = arguments.indexOf(OPTION);
                if (arguments.size() > index) {
                    return arguments.get(index + 1);
                }
            }
            if (arguments.contains(ALIAS)) {
                index = arguments.indexOf(ALIAS);
                if (arguments.size() > index) {
                    return arguments.get(index + 1);
                }
            }
        }
        return pid;
    }

    private Set<String> getPropertyNames(String pid) {
        HashSet<String> propertyNames = new HashSet<String>();
        if (pid != null) {
            Configuration configuration = null;
            try {
                Dictionary properties;
                Configuration[] configs = this.configAdmin.listConfigurations("(service.pid=" + pid + ")");
                if (configs != null && configs.length > 0 && (configuration = configs[0]) != null && (properties = configuration.getProperties()) != null) {
                    Enumeration keys = properties.keys();
                    while (keys.hasMoreElements()) {
                        propertyNames.add(String.valueOf(keys.nextElement()));
                    }
                }
            }
            catch (IOException iOException) {
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
        return propertyNames;
    }

    public ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }
}

