/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.aries.blueprint.Interceptor;
import org.apache.aries.blueprint.ServiceProcessor;
import org.apache.aries.blueprint.container.AggregateConverter;
import org.apache.aries.blueprint.container.BeanRecipe;
import org.apache.aries.blueprint.container.BlueprintContainerImpl;
import org.apache.aries.blueprint.container.BlueprintRepository;
import org.apache.aries.blueprint.container.DestroyCallback;
import org.apache.aries.blueprint.container.QuiesceInterceptor;
import org.apache.aries.blueprint.di.AbstractRecipe;
import org.apache.aries.blueprint.di.CollectionRecipe;
import org.apache.aries.blueprint.di.ExecutionContext;
import org.apache.aries.blueprint.di.MapRecipe;
import org.apache.aries.blueprint.di.Recipe;
import org.apache.aries.blueprint.parser.ComponentDefinitionRegistryImpl;
import org.apache.aries.blueprint.proxy.CollaboratorFactory;
import org.apache.aries.blueprint.proxy.ProxyUtils;
import org.apache.aries.blueprint.utils.JavaUtils;
import org.apache.aries.blueprint.utils.ReflectionUtils;
import org.apache.aries.blueprint.utils.ServiceListener;
import org.apache.aries.proxy.InvocationListener;
import org.apache.aries.util.AriesFrameworkUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.container.ReifiedType;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.RefMetadata;
import org.osgi.service.blueprint.reflect.ServiceMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRecipe
extends AbstractRecipe {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceRecipe.class);
    static final String LOG_ENTRY = "Method entry: {}, args {}";
    static final String LOG_EXIT = "Method exit: {}, returning {}";
    private final BlueprintContainerImpl blueprintContainer;
    private final ServiceMetadata metadata;
    private final Recipe serviceRecipe;
    private final CollectionRecipe listenersRecipe;
    private final MapRecipe propertiesRecipe;
    private final List<Recipe> explicitDependencies;
    private Map properties;
    private final AtomicReference<ServiceRegistration> registration = new AtomicReference();
    private Map registrationProperties;
    private List<ServiceListener> listeners;
    private volatile Object service;
    private final Object monitor = new Object();
    private final AtomicInteger activeCalls = new AtomicInteger(0);
    private volatile boolean quiesce;
    private Collection<DestroyCallback> destroyCallbacks = new ArrayList<DestroyCallback>();
    private boolean initialServiceRegistration = true;

    public ServiceRecipe(String name, BlueprintContainerImpl blueprintContainer, ServiceMetadata metadata, Recipe serviceRecipe, CollectionRecipe listenersRecipe, MapRecipe propertiesRecipe, List<Recipe> explicitDependencies) {
        super(name);
        this.prototype = false;
        this.blueprintContainer = blueprintContainer;
        this.metadata = metadata;
        this.serviceRecipe = serviceRecipe;
        this.listenersRecipe = listenersRecipe;
        this.propertiesRecipe = propertiesRecipe;
        this.explicitDependencies = explicitDependencies;
    }

    public Recipe getServiceRecipe() {
        return this.serviceRecipe;
    }

    public CollectionRecipe getListenersRecipe() {
        return this.listenersRecipe;
    }

    @Override
    public List<Recipe> getConstructorDependencies() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        if (this.explicitDependencies != null) {
            recipes.addAll(this.explicitDependencies);
        }
        return recipes;
    }

    @Override
    public List<Recipe> getDependencies() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        if (this.serviceRecipe != null) {
            recipes.add(this.serviceRecipe);
        }
        if (this.listenersRecipe != null) {
            recipes.add(this.listenersRecipe);
        }
        if (this.propertiesRecipe != null) {
            recipes.add(this.propertiesRecipe);
        }
        recipes.addAll(this.getConstructorDependencies());
        return recipes;
    }

    @Override
    protected Object internalCreate() throws ComponentDefinitionException {
        ServiceRegistrationProxy proxy = new ServiceRegistrationProxy();
        this.addPartialObject(proxy);
        this.internalGetService(null, null);
        return proxy;
    }

    public boolean isRegistered() {
        return this.registration.get() != null;
    }

    public void register() {
        ServiceRegistration reg;
        int state = this.blueprintContainer.getBundleContext().getBundle().getState();
        if (state != 32 && state != 8) {
            return;
        }
        this.createExplicitDependencies();
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        if (this.properties == null) {
            this.properties = (Map)this.createRecipe(this.propertiesRecipe);
        }
        props.putAll(this.properties);
        if (this.metadata.getRanking() == 0) {
            props.remove("service.ranking");
        } else {
            props.put("service.ranking", this.metadata.getRanking());
        }
        String componentName = this.getComponentName();
        if (componentName != null) {
            props.put("osgi.service.blueprint.compname", componentName);
        } else {
            props.remove("osgi.service.blueprint.compname");
        }
        for (ServiceProcessor processor : this.blueprintContainer.getProcessors(ServiceProcessor.class)) {
            processor.updateProperties(new PropertiesUpdater(), props);
        }
        this.registrationProperties = props;
        Set<String> classes = this.getClasses();
        String[] classArray = classes.toArray(new String[classes.size()]);
        LOGGER.debug("Registering service {} with interfaces {} and properties {}", new Object[]{this.name, classes, props});
        if (this.registration.get() == null && !this.registration.compareAndSet(null, reg = this.blueprintContainer.registerService(classArray, new TriggerServiceFactory(this, this.metadata), props)) && this.registration.get() != reg) {
            reg.unregister();
        }
        this.initialServiceRegistration = false;
    }

    public void unregister() {
        ServiceRegistration reg = this.registration.get();
        if (reg != null) {
            LOGGER.debug("Unregistering service {}", (Object)this.name);
            if (this.listeners != null) {
                LOGGER.debug("Calling listeners for service unregistration");
                for (ServiceListener listener : this.listeners) {
                    listener.unregister(this.service, this.registrationProperties);
                }
            }
            AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)reg);
            this.registration.compareAndSet(reg, null);
        }
    }

    protected ServiceReference getReference() {
        ServiceRegistration reg = this.registration.get();
        if (reg == null) {
            throw new IllegalStateException("Service is not registered");
        }
        return reg.getReference();
    }

    protected void setProperties(Dictionary props) {
        ServiceRegistration reg = this.registration.get();
        if (reg == null) {
            throw new IllegalStateException("Service is not registered");
        }
        reg.setProperties(props);
    }

    protected Object internalGetService() {
        return this.internalGetService(this.blueprintContainer.getBundleContext().getBundle(), null);
    }

    private Object internalGetService(Bundle bundle, ServiceRegistration registration) {
        LOGGER.debug("Retrieving service for bundle {} and service registration {}", (Object)bundle, (Object)registration);
        this.createService();
        Object service = this.service;
        if (bundle != null) {
            if (service instanceof ServiceFactory) {
                service = ((ServiceFactory)service).getService(bundle, registration);
            }
            if (service == null) {
                throw new IllegalStateException("service is null");
            }
            this.validateClasses(service);
        } else if (!(service instanceof ServiceFactory)) {
            this.validateClasses(service);
        }
        return service;
    }

    private void createService() {
        try {
            if (this.service == null) {
                LOGGER.debug("Creating service instance");
                Iterator<ServiceListener> old = ExecutionContext.Holder.setContext(this.blueprintContainer.getRepository());
                try {
                    Object o = this.serviceRecipe.create();
                    if (o instanceof AggregateConverter.Convertible) {
                        o = this.blueprintContainer.getRepository().convert(o, new ReifiedType(Object.class));
                        this.validateClasses(o);
                    } else if (o instanceof BeanRecipe.UnwrapperedBeanHolder) {
                        BeanRecipe.UnwrapperedBeanHolder holder = (BeanRecipe.UnwrapperedBeanHolder)o;
                        if (holder.unwrapperedBean instanceof ServiceFactory) {
                            LOGGER.debug("{} implements ServiceFactory, creating proxy that also implements this", holder.unwrapperedBean);
                            Collection<Class<?>> cls = this.getClassesForProxying(holder.unwrapperedBean);
                            cls.add(this.blueprintContainer.loadClass("org.osgi.framework.ServiceFactory"));
                            o = BeanRecipe.wrap(holder, cls);
                        } else {
                            this.validateClasses(holder.unwrapperedBean);
                            o = BeanRecipe.wrap(holder, this.getClassesForProxying(holder.unwrapperedBean));
                        }
                    } else if (!(o instanceof ServiceFactory)) {
                        this.validateClasses(o);
                    }
                    this.service = o;
                }
                catch (Exception e) {
                    LOGGER.error("Error retrieving service from " + this, (Throwable)e);
                    throw new ComponentDefinitionException((Throwable)e);
                }
                finally {
                    ExecutionContext.Holder.setContext((ExecutionContext)((Object)old));
                }
                LOGGER.debug("Service created: {}", this.service);
            }
            if (!this.initialServiceRegistration && this.listeners == null) {
                LOGGER.debug("Creating listeners");
                this.listeners = this.listenersRecipe != null ? (List<Object>)this.createRecipe(this.listenersRecipe) : Collections.emptyList();
                LOGGER.debug("Listeners created: {}", this.listeners);
                if (this.registration.get() != null) {
                    LOGGER.debug("Calling listeners for initial service registration");
                    for (ServiceListener listener : this.listeners) {
                        listener.register(this.service, this.registrationProperties);
                    }
                } else {
                    LOGGER.debug("Calling listeners for initial service unregistration");
                    for (ServiceListener listener : this.listeners) {
                        listener.unregister(this.service, this.registrationProperties);
                    }
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("Error retrieving service from " + this, (Throwable)e);
            throw e;
        }
    }

    private void validateClasses(Object service) {
        if (this.metadata.getAutoExport() == 1) {
            HashSet<String> allClasses = new HashSet<String>();
            ReflectionUtils.getSuperClasses(allClasses, service.getClass());
            ReflectionUtils.getImplementedInterfaces(allClasses, service.getClass());
            Set<String> classes = this.getClasses();
            classes.removeAll(allClasses);
            if (!classes.isEmpty()) {
                throw new ComponentDefinitionException("The service implementation does not implement the required interfaces: " + classes);
            }
        }
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        this.registration.compareAndSet(null, registration);
        return this.internalGetService(bundle, registration);
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        if (this.service instanceof ServiceFactory) {
            ((ServiceFactory)this.service).ungetService(bundle, registration, service);
        }
    }

    private Set<String> getClasses() {
        Set<Object> classes;
        switch (this.metadata.getAutoExport()) {
            case 2: {
                classes = ReflectionUtils.getImplementedInterfaces(new HashSet<String>(), this.internalGetService().getClass());
                break;
            }
            case 3: {
                classes = ReflectionUtils.getSuperClasses(new HashSet<String>(), this.internalGetService().getClass());
                break;
            }
            case 4: {
                classes = ReflectionUtils.getSuperClasses(new HashSet<String>(), this.internalGetService().getClass());
                classes = ReflectionUtils.getImplementedInterfaces(classes, this.internalGetService().getClass());
                break;
            }
            default: {
                classes = new HashSet(this.metadata.getInterfaces());
            }
        }
        return classes;
    }

    private Collection<Class<?>> getClassesForProxying(Object template) throws ClassNotFoundException {
        Collection<Class<?>> classes;
        switch (this.metadata.getAutoExport()) {
            case 2: {
                classes = ReflectionUtils.getImplementedInterfacesAsClasses(new HashSet(), template.getClass());
                break;
            }
            case 3: 
            case 4: {
                classes = ProxyUtils.asList(template.getClass());
                break;
            }
            default: {
                classes = new HashSet(this.convertStringsToClasses(this.metadata.getInterfaces()));
            }
        }
        return classes;
    }

    private Collection<? extends Class<?>> convertStringsToClasses(List<String> interfaces) throws ClassNotFoundException {
        HashSet<Class> classes = new HashSet<Class>();
        for (String s : interfaces) {
            classes.add(this.blueprintContainer.loadClass(s));
        }
        return classes;
    }

    private void createExplicitDependencies() {
        if (this.explicitDependencies != null) {
            for (Recipe recipe : this.explicitDependencies) {
                this.createRecipe(recipe);
            }
        }
    }

    private Object createRecipe(Recipe recipe) {
        String name = recipe.getName();
        BlueprintRepository repo = this.blueprintContainer.getRepository();
        if (repo.getRecipe(name) != recipe) {
            repo.putRecipe(name, recipe);
        }
        return repo.create(name);
    }

    private String getComponentName() {
        if (this.metadata.getServiceComponent() instanceof RefMetadata) {
            RefMetadata ref = (RefMetadata)this.metadata.getServiceComponent();
            return ref.getComponentId();
        }
        return null;
    }

    protected void incrementActiveCalls() {
        this.activeCalls.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementActiveCalls() {
        int currentCount = this.activeCalls.decrementAndGet();
        if (currentCount == 0 && this.quiesce) {
            ArrayList<DestroyCallback> callbacksToCall;
            Iterator iterator = this.monitor;
            synchronized (iterator) {
                callbacksToCall = new ArrayList<DestroyCallback>(this.destroyCallbacks);
                this.destroyCallbacks.clear();
            }
            for (DestroyCallback cbk : callbacksToCall) {
                cbk.callback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesce(DestroyCallback destroyCallback) {
        this.unregister();
        this.quiesce = true;
        DestroyOnceCallback safeDestroyCallback = new DestroyOnceCallback(destroyCallback);
        Object object = this.monitor;
        synchronized (object) {
            this.destroyCallbacks.add(safeDestroyCallback);
        }
        if (this.activeCalls.get() == 0) {
            safeDestroyCallback.callback();
            object = this.monitor;
            synchronized (object) {
                this.destroyCallbacks.remove(safeDestroyCallback);
            }
        }
    }

    private boolean isClassAvailable(String clazz) {
        try {
            this.getClass().getClassLoader().loadClass(clazz);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    private class PropertiesUpdater
    implements ServiceProcessor.ServicePropertiesUpdater {
        private PropertiesUpdater() {
        }

        @Override
        public String getId() {
            return ServiceRecipe.this.metadata.getId();
        }

        @Override
        public void updateProperties(Dictionary properties) {
            Hashtable table = JavaUtils.getProperties(ServiceRecipe.this.getReference());
            JavaUtils.copy(table, properties);
            ServiceRecipe.this.setProperties(table);
        }
    }

    private class ServiceRegistrationProxy
    implements ServiceRegistration {
        private ServiceRegistrationProxy() {
        }

        public ServiceReference getReference() {
            return ServiceRecipe.this.getReference();
        }

        public void setProperties(Dictionary properties) {
            ServiceRecipe.this.setProperties(properties);
        }

        public void unregister() {
            throw new UnsupportedOperationException();
        }
    }

    private class TriggerServiceFactory
    implements ServiceFactory {
        private ServiceRecipe serviceRecipe;
        private ComponentMetadata cm;
        private ServiceMetadata sm;
        private boolean isQuiesceAvailable;

        public TriggerServiceFactory(ServiceRecipe serviceRecipe2, ServiceMetadata cm) {
            this.serviceRecipe = serviceRecipe2;
            this.cm = cm;
            this.sm = cm;
            this.isQuiesceAvailable = ServiceRecipe.this.isClassAvailable("org.apache.aries.quiesce.participant.QuiesceParticipant");
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            Object intercepted;
            Object original = ServiceRecipe.this.getService(bundle, registration);
            LOGGER.debug(ServiceRecipe.LOG_ENTRY, (Object)"getService", original);
            ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
            ComponentDefinitionRegistryImpl reg = ServiceRecipe.this.blueprintContainer.getComponentDefinitionRegistry();
            List<Interceptor> registeredInterceptors = reg.getInterceptors(this.cm);
            if (registeredInterceptors != null) {
                interceptors.addAll(registeredInterceptors);
            }
            if (this.isQuiesceAvailable) {
                interceptors.add(new QuiesceInterceptor(this.serviceRecipe));
            }
            if (interceptors.isEmpty()) {
                return original;
            }
            try {
                Bundle b = FrameworkUtil.getBundle(original.getClass());
                if (b == null) {
                    b = ServiceRecipe.this.blueprintContainer.getBundleContext().getBundle();
                }
                InvocationListener collaborator = CollaboratorFactory.create(this.cm, interceptors);
                intercepted = ServiceRecipe.this.blueprintContainer.getProxyManager().createInterceptingProxy(b, ServiceRecipe.this.getClassesForProxying(original), original, collaborator);
            }
            catch (Exception u) {
                Bundle b = ServiceRecipe.this.blueprintContainer.getBundleContext().getBundle();
                LOGGER.info("Unable to create a proxy object for the service " + ServiceRecipe.this.getName() + " defined in bundle " + b.getSymbolicName() + "/" + b.getVersion() + " with id. Returning the original object instead.", (Throwable)u);
                LOGGER.debug(ServiceRecipe.LOG_EXIT, (Object)"getService", original);
                return original;
            }
            LOGGER.debug(ServiceRecipe.LOG_EXIT, (Object)"getService", intercepted);
            return intercepted;
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            ServiceRecipe.this.ungetService(bundle, registration, service);
        }
    }

    private static class DestroyOnceCallback
    implements DestroyCallback {
        private final DestroyCallback destroyCallback;
        private final AtomicBoolean isDestroyed = new AtomicBoolean(false);

        public DestroyOnceCallback(DestroyCallback destroyCallback) {
            this.destroyCallback = destroyCallback;
        }

        @Override
        public void callback() {
            if (this.isDestroyed.compareAndSet(false, true)) {
                this.destroyCallback.callback();
            }
        }
    }
}

