/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.diagnostic.command;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.diagnostic.core.Dump;
import org.apache.karaf.diagnostic.core.DumpDestination;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.osgi.framework.BundleContext;

@Command(scope="dev", name="create-dump", description="Creates zip archive with diagnostic info.")
public class DumpCommand
extends OsgiCommandSupport {
    private BundleContext bundleContext;
    private SimpleDateFormat dumpFormat = new SimpleDateFormat("yyyy-MM-dd_HHmmss");
    @Option(name="-d", aliases={"--directory"}, description="Creates dump in directory in place of a ZIP archive")
    boolean directory;
    @Argument(name="name", description="Name of created zip or directory", required=false)
    String fileName;

    protected Object doExecute() throws Exception {
        if (this.fileName == null || this.fileName.trim().length() == 0) {
            this.fileName = this.dumpFormat.format(new Date());
            if (!this.directory) {
                this.fileName = this.fileName + ".zip";
            }
        }
        File target = new File(this.fileName);
        DumpDestination destination = this.directory ? Dump.directory((File)target) : Dump.zip((File)target);
        Dump.dump((BundleContext)this.bundleContext, (DumpDestination)destination);
        this.session.getConsole().println("Diagnostic dump created.");
        return null;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

