/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.admin.command;

import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.admin.command.AdminCommandSupport;

@Command(scope="admin", name="connect", description="Connects to an existing container instance.")
public class ConnectCommand
extends AdminCommandSupport {
    @Option(name="-u", aliases={"--username"}, description="Remote user name", required=false, multiValued=false)
    private String username;
    @Option(name="-p", aliases={"--password"}, description="Remote password", required=false, multiValued=false)
    private String password;
    @Argument(index=0, name="name", description="The name of the container instance", required=true, multiValued=false)
    private String instance = null;
    @Argument(index=1, name="command", description="Optional command to execute", required=false, multiValued=true)
    private List<String> command;

    protected Object doExecute() throws Exception {
        String cmdStr = "";
        if (this.command != null) {
            StringBuilder sb = new StringBuilder();
            for (String cmd : this.command) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(cmd);
            }
            cmdStr = "'" + sb.toString().replaceAll("'", "\\'") + "'";
        }
        int port = this.getExistingInstance(this.instance).getSshPort();
        if (this.username != null) {
            if (this.password == null) {
                this.session.execute((CharSequence)("ssh -l " + this.username + " -p " + port + " localhost " + cmdStr));
            } else {
                this.session.execute((CharSequence)("ssh -l " + this.username + " -P " + this.password + " -p " + port + " localhost " + cmdStr));
            }
        } else {
            this.session.execute((CharSequence)("ssh -p " + port + " localhost " + cmdStr));
        }
        return null;
    }
}

