/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.encryption;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.karaf.jaas.modules.Encryption;
import org.apache.karaf.jaas.modules.EncryptionService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptionSupport {
    private final Logger logger = LoggerFactory.getLogger(EncryptionSupport.class);
    private BundleContext bundleContext;
    private Encryption encryption;
    private String encryptionPrefix;
    private String encryptionSuffix;
    protected Map<String, ?> options;
    protected boolean debug;

    public EncryptionSupport(Map<String, ?> options) {
        this.options = options;
        this.debug = Boolean.parseBoolean((String)options.get("debug"));
        this.bundleContext = (BundleContext)options.get(BundleContext.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Encryption getEncryption() {
        if (this.encryption == null) {
            HashMap<String, String> encOpts = new HashMap<String, String>();
            for (String key : this.options.keySet()) {
                if (!key.startsWith("encryption.")) continue;
                encOpts.put(key.substring("encryption.".length()), this.options.get(key).toString());
            }
            this.encryptionPrefix = (String)encOpts.remove("prefix");
            this.encryptionSuffix = (String)encOpts.remove("suffix");
            boolean enabled = Boolean.parseBoolean((String)encOpts.remove("enabled"));
            if (!enabled) {
                if (this.debug) {
                    this.logger.debug("Encryption is disabled.");
                }
            } else {
                Object[] encryptionServiceReferences;
                String name = (String)encOpts.remove("name");
                if (this.debug) {
                    if (name != null && name.length() > 0) {
                        this.logger.debug("Encryption is enabled. Using service " + name + " with options " + encOpts);
                    } else {
                        this.logger.debug("Encryption is enabled. Using options " + encOpts);
                    }
                }
                try {
                    encryptionServiceReferences = this.bundleContext.getServiceReferences(EncryptionService.class.getName(), name != null && name.length() > 0 ? "(name=" + name + ")" : null);
                    int timeout = 0;
                    while (encryptionServiceReferences == null || encryptionServiceReferences.length == 0) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        encryptionServiceReferences = this.bundleContext.getServiceReferences(EncryptionService.class.getName(), name != null && name.length() > 0 ? "(name=" + name + ")" : null);
                        if (++timeout != 40) continue;
                        break;
                    }
                }
                catch (InvalidSyntaxException e) {
                    throw new IllegalStateException("The encryption service filter is not well formed.", e);
                }
                if (encryptionServiceReferences == null || encryptionServiceReferences.length == 0) {
                    if (name != null && name.length() > 0) {
                        throw new IllegalStateException("Encryption service " + name + " not found. Please check that the encryption service is correctly set up.");
                    }
                    throw new IllegalStateException("No encryption service found. Please install the Karaf encryption feature and check that the encryption algorithm is supported.");
                }
                Arrays.sort(encryptionServiceReferences);
                for (Object ref : encryptionServiceReferences) {
                    try {
                        EncryptionService encryptionService = (EncryptionService)this.bundleContext.getService((ServiceReference)ref);
                        if (encryptionService == null) continue;
                        try {
                            this.encryption = encryptionService.createEncryption(encOpts);
                            if (this.encryption == null) continue;
                            break;
                        }
                        finally {
                            this.bundleContext.ungetService((ServiceReference)ref);
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                if (this.encryption == null) {
                    throw new IllegalStateException("No EncryptionService supporting the required options could be found.");
                }
            }
        }
        return this.encryption;
    }

    public String getEncryptionSuffix() {
        return this.encryptionSuffix;
    }

    public void setEncryptionSuffix(String encryptionSuffix) {
        this.encryptionSuffix = encryptionSuffix;
    }

    public String getEncryptionPrefix() {
        return this.encryptionPrefix;
    }

    public void setEncryptionPrefix(String encryptionPrefix) {
        this.encryptionPrefix = encryptionPrefix;
    }
}

