/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.ldap;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.karaf.jaas.config.KeystoreManager;
import org.apache.karaf.jaas.modules.ldap.LDAPLoginModule;
import org.apache.karaf.jaas.modules.ldap.ManagedSSLSocketFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPOptions {
    public static final String CONNECTION_URL = "connection.url";
    public static final String CONNECTION_USERNAME = "connection.username";
    public static final String CONNECTION_PASSWORD = "connection.password";
    public static final String USER_BASE_DN = "user.base.dn";
    public static final String USER_FILTER = "user.filter";
    public static final String USER_SEARCH_SUBTREE = "user.search.subtree";
    public static final String ROLE_BASE_DN = "role.base.dn";
    public static final String ROLE_FILTER = "role.filter";
    public static final String ROLE_NAME_ATTRIBUTE = "role.name.attribute";
    public static final String ROLE_SEARCH_SUBTREE = "role.search.subtree";
    public static final String ROLE_MAPPING = "role.mapping";
    public static final String AUTHENTICATION = "authentication";
    public static final String ALLOW_EMPTY_PASSWORDS = "allowEmptyPasswords";
    public static final String DISABLE_CACHE = "disableCache";
    public static final String INITIAL_CONTEXT_FACTORY = "initial.context.factory";
    public static final String CONTEXT_PREFIX = "context.";
    public static final String SSL = "ssl";
    public static final String SSL_PROVIDER = "ssl.provider";
    public static final String SSL_PROTOCOL = "ssl.protocol";
    public static final String SSL_ALGORITHM = "ssl.algorithm";
    public static final String SSL_KEYSTORE = "ssl.keystore";
    public static final String SSL_KEYALIAS = "ssl.keyalias";
    public static final String SSL_TRUSTSTORE = "ssl.truststore";
    public static final String SSL_TIMEOUT = "ssl.timeout";
    public static final String DEFAULT_INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    public static final String DEFAULT_AUTHENTICATION = "simple";
    public static final int DEFAULT_SSL_TIMEOUT = 10;
    private static Logger LOGGER = LoggerFactory.getLogger(LDAPLoginModule.class);
    private final Map<String, ?> options;

    public LDAPOptions(Map<String, ?> options) {
        this.options = new HashMap(options);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LDAPOptions that = (LDAPOptions)o;
        return this.options.equals(that.options);
    }

    public int hashCode() {
        return this.options.hashCode();
    }

    public String getUserFilter() {
        return (String)this.options.get(USER_FILTER);
    }

    public String getUserBaseDn() {
        return (String)this.options.get(USER_BASE_DN);
    }

    public boolean getUserSearchSubtree() {
        return Boolean.parseBoolean((String)this.options.get(USER_SEARCH_SUBTREE));
    }

    public String getRoleFilter() {
        return (String)this.options.get(ROLE_FILTER);
    }

    public String getRoleBaseDn() {
        return (String)this.options.get(ROLE_BASE_DN);
    }

    public boolean getRoleSearchSubtree() {
        return Boolean.parseBoolean((String)this.options.get(ROLE_SEARCH_SUBTREE));
    }

    public String getRoleNameAttribute() {
        return (String)this.options.get(ROLE_NAME_ATTRIBUTE);
    }

    public Map<String, Set<String>> getRoleMapping() {
        return this.parseRoleMapping((String)this.options.get(ROLE_MAPPING));
    }

    private Map<String, Set<String>> parseRoleMapping(String option) {
        HashMap<String, Set<String>> roleMapping = new HashMap<String, Set<String>>();
        if (option != null) {
            String[] mappings;
            LOGGER.debug("Parse role mapping {}", (Object)option);
            for (String mapping : mappings = option.split(";")) {
                String[] map = mapping.split("=", 2);
                String ldapRole = map[0].trim();
                String[] karafRoles = map[1].split(",");
                if (roleMapping.get(ldapRole) == null) {
                    roleMapping.put(ldapRole, new HashSet());
                }
                Set karafRolesSet = (Set)roleMapping.get(ldapRole);
                for (String karafRole : karafRoles) {
                    karafRolesSet.add(karafRole.trim());
                }
            }
        }
        return roleMapping;
    }

    public Hashtable<String, Object> getEnv() throws NamingException {
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        for (String key : this.options.keySet()) {
            if (!key.startsWith(CONTEXT_PREFIX)) continue;
            env.put(key.substring(CONTEXT_PREFIX.length()), this.options.get(key));
        }
        env.put("java.naming.factory.initial", this.getInitialContextFactory());
        env.put("java.naming.provider.url", this.getConnectionURL());
        if (this.getConnectionUsername() != null && this.getConnectionUsername().trim().length() > 0) {
            env.put("java.naming.security.authentication", this.getAuthentication());
            env.put("java.naming.security.principal", this.getConnectionUsername());
            env.put("java.naming.security.credentials", this.getConnectionPassword());
        }
        if (this.getSsl()) {
            this.setupSsl(env);
        }
        return env;
    }

    protected void setupSsl(Hashtable<String, Object> env) throws NamingException {
        BundleContext bundleContext = FrameworkUtil.getBundle(LDAPOptions.class).getBundleContext();
        ServiceReference ref = null;
        try {
            LOGGER.debug("Setting up SSL");
            env.put("java.naming.security.protocol", SSL);
            env.put("java.naming.ldap.factory.socket", ManagedSSLSocketFactory.class.getName());
            ref = bundleContext.getServiceReference(KeystoreManager.class.getName());
            KeystoreManager manager = (KeystoreManager)bundleContext.getService(ref);
            SSLSocketFactory factory = manager.createSSLFactory(this.getSslProvider(), this.getSslProtocol(), this.getSslAlgorithm(), this.getSslKeystore(), this.getSslKeyAlias(), this.getSslTrustStore(), (long)this.getSslTimeout());
            ManagedSSLSocketFactory.setSocketFactory(factory);
            Thread.currentThread().setContextClassLoader(ManagedSSLSocketFactory.class.getClassLoader());
        }
        catch (Exception e) {
            try {
                throw new NamingException("Unable to setup SSL support for LDAP: " + e.getMessage());
            }
            catch (Throwable throwable) {
                bundleContext.ungetService(ref);
                throw throwable;
            }
        }
        bundleContext.ungetService(ref);
    }

    public Object getInitialContextFactory() {
        String initialContextFactory = (String)this.options.get(INITIAL_CONTEXT_FACTORY);
        if (initialContextFactory == null) {
            initialContextFactory = DEFAULT_INITIAL_CONTEXT_FACTORY;
        }
        return initialContextFactory;
    }

    public String getConnectionURL() {
        String connectionURL = (String)this.options.get(CONNECTION_URL);
        if (connectionURL == null || connectionURL.trim().length() == 0) {
            LOGGER.error("No LDAP URL specified.");
        } else if (!connectionURL.startsWith("ldap:") && !connectionURL.startsWith("ldaps:")) {
            LOGGER.error("Invalid LDAP URL: " + connectionURL);
        }
        return connectionURL;
    }

    public String getConnectionUsername() {
        return (String)this.options.get(CONNECTION_USERNAME);
    }

    public String getConnectionPassword() {
        return (String)this.options.get(CONNECTION_PASSWORD);
    }

    public String getAuthentication() {
        String authentication = (String)this.options.get(AUTHENTICATION);
        if (authentication == null) {
            authentication = DEFAULT_AUTHENTICATION;
        }
        return authentication;
    }

    public boolean getSsl() {
        Object val = this.options.get(SSL);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val != null) {
            return Boolean.parseBoolean(val.toString());
        }
        return this.getConnectionURL().startsWith("ldaps:");
    }

    public String getSslProvider() {
        return (String)this.options.get(SSL_PROVIDER);
    }

    public String getSslProtocol() {
        return (String)this.options.get(SSL_PROTOCOL);
    }

    public String getSslAlgorithm() {
        return (String)this.options.get(SSL_ALGORITHM);
    }

    public String getSslKeystore() {
        return (String)this.options.get(SSL_KEYSTORE);
    }

    public String getSslKeyAlias() {
        return (String)this.options.get(SSL_KEYALIAS);
    }

    public String getSslTrustStore() {
        return (String)this.options.get(SSL_TRUSTSTORE);
    }

    public int getSslTimeout() {
        Object val = this.options.get(SSL_TIMEOUT);
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        if (val != null) {
            return Integer.parseInt(val.toString());
        }
        return 10;
    }

    public boolean getAllowEmptyPasswords() {
        return Boolean.parseBoolean((String)this.options.get(ALLOW_EMPTY_PASSWORDS));
    }

    public boolean getDisableCache() {
        return Boolean.parseBoolean((String)this.options.get(DISABLE_CACHE));
    }
}

