/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.net.URI;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.command.FeaturesCommandSupport;

@Command(scope="features", name="listUrl", description="Displays a list of all defined repository URLs.")
public class ListUrlCommand
extends FeaturesCommandSupport {
    @Option(name="-v", aliases={"-validate"}, description="Validate current version of descriptors", required=false, multiValued=false)
    boolean validation = false;
    @Option(name="-vo", aliases={"-verbose"}, description="Shows validation output", required=false, multiValued=false)
    boolean verbose = false;

    @Override
    protected void doExecute(FeaturesService admin) throws Exception {
        Repository[] repos = admin.listRepositories();
        String header = this.validation ? " Loaded   Now valid   URI " : " Loaded   URI ";
        System.out.println(header);
        String verboseOutput = "";
        if (repos != null && repos.length > 0) {
            for (int i = 0; i < repos.length; ++i) {
                if (repos[i] == null) continue;
                URI uri = repos[i].getURI();
                String line = "";
                line = line + (repos[i].isValid() ? "  true " : "  false");
                if (this.validation) {
                    try {
                        admin.validateRepository(uri);
                        line = line + "     true   ";
                    }
                    catch (Exception e) {
                        line = line + "     false  ";
                        verboseOutput = verboseOutput + uri + ":" + e.getMessage() + "\n";
                    }
                }
                System.out.println(line + "   " + uri);
            }
            if (this.verbose) {
                System.out.println("Validation output:\n" + verboseOutput);
            }
        } else {
            System.out.println("No repository URLs are set.");
        }
    }
}

