/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.config;

import java.util.Dictionary;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.config.ConfigCommandSupport;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="config", name="update", description="Saves and propagates changes from the configuration being edited.")
public class UpdateCommand
extends ConfigCommandSupport {
    @Option(name="-b", aliases={"--bypass-storage"}, multiValued=false, required=false, description="Do not store the configuration in a properties file, but feed it directly to ConfigAdmin")
    protected boolean bypassStorage;

    @Override
    protected void doExecute(ConfigurationAdmin admin) throws Exception {
        Dictionary<String, Object> props = this.getEditedProps();
        if (props == null) {
            System.err.println("No configuration is being edited--run the edit command first");
            return;
        }
        String pid = (String)this.session.get("ConfigCommand.PID");
        this.update(admin, pid, props, this.bypassStorage);
        this.session.put("ConfigCommand.PID", null);
        this.session.put("ConfigCommand.Props", null);
    }
}

