/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.service.log;

public class LogUtil {
    public static String fromLevel(int level) {
        return LogUtil.fromLevel(level, 0);
    }

    public static String fromLevel(int level, int length) {
        StringBuffer sb = new StringBuffer(length > 7 ? length : 7);
        switch (level) {
            case 3: {
                sb.append("info");
                break;
            }
            case 4: {
                sb.append("debug");
                break;
            }
            case 2: {
                sb.append("Warning");
                break;
            }
            case 1: {
                sb.append("ERROR");
                break;
            }
            case 0: {
                sb.append("DEFAULT");
                break;
            }
            default: {
                sb.append("[");
                sb.append(level);
                sb.append("]");
            }
        }
        for (int i = sb.length(); i < length; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static int toLevel(String level, int def) {
        if (level.equalsIgnoreCase("INFO")) {
            return 3;
        }
        if (level.equalsIgnoreCase("DEBUG")) {
            return 4;
        }
        if (level.equalsIgnoreCase("WARNING")) {
            return 2;
        }
        if (level.equalsIgnoreCase("ERROR")) {
            return 1;
        }
        if (level.equalsIgnoreCase("DEFAULT")) {
            return 0;
        }
        return def;
    }
}

