/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class MBeanRegistrer {
    private MBeanServer mbeanServer;
    private Map<Object, String> mbeans;
    private Set<String> registered = new HashSet<String>();

    public void setMbeans(Map<Object, String> mbeans) {
        this.mbeans = mbeans;
    }

    public void registerMBeanServer(MBeanServer mbeanServer) throws JMException {
        if (this.mbeanServer != mbeanServer) {
            this.unregisterMBeans();
        }
        this.mbeanServer = mbeanServer;
        this.registerMBeans();
    }

    public void unregisterMBeanServer(MBeanServer mbeanServer) throws JMException {
        this.unregisterMBeans();
        this.mbeanServer = null;
    }

    public void init() throws Exception {
        this.registerMBeans();
    }

    public void destroy() throws Exception {
        this.unregisterMBeans();
    }

    protected void registerMBeans() throws JMException {
        if (this.mbeanServer != null && this.mbeans != null) {
            for (Map.Entry<Object, String> entry : this.mbeans.entrySet()) {
                String value = this.parseProperty(entry.getValue());
                this.mbeanServer.registerMBean(entry.getKey(), new ObjectName(value));
                this.registered.add(value);
            }
        }
    }

    protected void unregisterMBeans() throws JMException {
        if (this.mbeanServer != null && this.mbeans != null) {
            while (!this.registered.isEmpty()) {
                String name = this.registered.iterator().next();
                this.mbeanServer.unregisterMBean(new ObjectName(name));
                this.registered.remove(name);
            }
        }
    }

    protected String parseProperty(String raw) {
        String var;
        String val;
        if (raw.indexOf("${") > -1 && raw.indexOf("}", raw.indexOf("${")) > -1 && (val = System.getProperty(var = raw.substring(raw.indexOf("${") + 2, raw.indexOf("}")))) != null) {
            raw = raw.replace("${" + var + "}", val);
        }
        return raw;
    }
}

