/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.command;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.command.JaasCommandSupport;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.jaas.modules.BackingEngine;

@Command(scope="jaas", name="users", description="List the users of the selected JAAS Realm/Login Module")
public class ListUsersCommand
extends JaasCommandSupport {
    private static final String OUTPUT_FORMAT = "%-20s %-20s %-20s";

    @Override
    protected Object doExecute() throws Exception {
        JaasRealm realm = (JaasRealm)this.session.get("JaasCommand.REALM");
        AppConfigurationEntry entry = (AppConfigurationEntry)this.session.get("JaasCommand.ENTRY");
        if (realm == null || entry == null) {
            System.err.println("No JAAS Realm / Module has been selected.");
            return null;
        }
        BackingEngine engine = this.backingEngineService.get(entry);
        if (engine == null) {
            System.err.println("Can't get the list of users (no backing engine service registered)");
            return null;
        }
        return this.doExecute(engine);
    }

    @Override
    protected Object doExecute(BackingEngine engine) throws Exception {
        List users = engine.listUsers();
        System.out.println(String.format(OUTPUT_FORMAT, "User Name", "Group", "Role"));
        for (UserPrincipal user : users) {
            ArrayList<String> reportedRoles = new ArrayList<String>();
            String userName = user.getName();
            for (GroupPrincipal group : engine.listGroups(user)) {
                String groupName = group.getName();
                reportedRoles.addAll(this.displayRole(engine, userName, groupName, (Principal)group));
            }
            reportedRoles.addAll(this.displayRole(engine, userName, "", (Principal)user, reportedRoles));
            if (reportedRoles.size() != 0) continue;
            System.out.println(String.format(OUTPUT_FORMAT, userName, "", ""));
        }
        return null;
    }

    private List<String> displayRole(BackingEngine engine, String userName, String groupName, Principal principal) {
        return this.displayRole(engine, userName, groupName, principal, Collections.emptyList());
    }

    private List<String> displayRole(BackingEngine engine, String userName, String groupName, Principal principal, List<String> excludedRoles) {
        ArrayList<String> names = new ArrayList<String>();
        List roles = engine.listRoles(principal);
        if (roles != null && roles.size() >= 1) {
            for (RolePrincipal role : roles) {
                String roleName = role.getName();
                if (excludedRoles.contains(roleName)) continue;
                names.add(roleName);
                System.out.println(String.format(OUTPUT_FORMAT, userName, groupName, roleName));
            }
        }
        return names;
    }
}

