/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.karaf.features.Conditional;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.internal.ContentImpl;
import org.apache.karaf.features.internal.FeatureImpl;

public class ConditionalImpl
extends ContentImpl
implements Conditional {
    private List<Feature> conditions = new ArrayList<Feature>();

    @Override
    public List<Feature> getCondition() {
        return this.conditions;
    }

    public void addCondition(Feature condition) {
        this.conditions.add(condition);
    }

    @Override
    public Feature asFeature(String name, String version) {
        String conditionName = name + "-condition-" + this.getConditionId().replaceAll("[^A-Za-z0-9 ]", "_");
        FeatureImpl f = new FeatureImpl(conditionName, version);
        f.getBundles().addAll(this.getBundles());
        f.getConfigurations().addAll(this.getConfigurations());
        f.getConfigurationFiles().addAll(this.getConfigurationFiles());
        f.getDependencies().addAll(this.getDependencies());
        return f;
    }

    private String getConditionId() {
        StringBuilder sb = new StringBuilder();
        Iterator<Feature> di = this.getCondition().iterator();
        while (di.hasNext()) {
            Feature dependency = di.next();
            sb.append(dependency.getName()).append("_").append(dependency.getVersion());
            if (!di.hasNext()) continue;
            sb.append("_");
        }
        return sb.toString();
    }
}

