/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.help;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.HelpProvider;
import org.apache.karaf.util.InterpolationHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class HelpSystem
implements HelpProvider {
    private BundleContext context;
    private ServiceTracker tracker;

    public void setContext(BundleContext context) {
        this.context = context;
    }

    public void start() {
        this.tracker = new ServiceTracker(this.context, HelpProvider.class.getName(), null);
        this.tracker.open();
    }

    public void stop() {
        this.tracker.close();
    }

    public synchronized List<HelpProvider> getProviders() {
        Object[] refs = this.tracker.getServiceReferences();
        Arrays.sort(refs);
        ArrayList<HelpProvider> providers = new ArrayList<HelpProvider>();
        for (int i = refs.length - 1; i >= 0; --i) {
            providers.add((HelpProvider)this.tracker.getService((ServiceReference)refs[i]));
        }
        return providers;
    }

    @Override
    public String getHelp(final CommandSession session, String path) {
        if (path == null) {
            path = "%root%";
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("data", "${" + path + "}");
        final List<HelpProvider> providers = this.getProviders();
        InterpolationHelper.performSubstitution(props, new InterpolationHelper.SubstitutionCallback(){

            @Override
            public String getValue(String key) {
                for (HelpProvider hp : providers) {
                    String help = hp.getHelp(session, key);
                    if (help == null) continue;
                    if (help.endsWith("\n")) {
                        help = help.substring(0, help.length() - 1);
                    }
                    return help;
                }
                return null;
            }
        });
        return (String)props.get("data");
    }
}

