/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.help;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import jline.Terminal;
import org.apache.felix.gogo.commands.basic.DefaultActionPreparator;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.HelpProvider;
import org.apache.karaf.shell.console.SubShell;
import org.fusesource.jansi.Ansi;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class SubShellHelpProvider
implements HelpProvider {
    private BundleContext context;
    private ServiceTracker tracker;

    public void setContext(BundleContext context) {
        this.context = context;
    }

    public void start() {
        this.tracker = new ServiceTracker(this.context, SubShell.class.getName(), null);
        this.tracker.open();
    }

    public void stop() {
        this.tracker.close();
    }

    @Override
    public String getHelp(CommandSession session, String path) {
        if (path.indexOf(124) > 0) {
            if (path.startsWith("subshell|")) {
                path = path.substring("subshell|".length());
            } else {
                return null;
            }
        }
        for (ServiceReference ref : this.tracker.getServiceReferences()) {
            if (!path.equals(ref.getProperty("name"))) continue;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.printSubShellHelp(session, ref.getBundle(), (SubShell)this.tracker.getService(ref), new PrintStream(baos, true));
            return baos.toString();
        }
        return null;
    }

    private void printSubShellHelp(CommandSession session, Bundle bundle, SubShell subShell, PrintStream out) {
        Terminal term = session != null ? (Terminal)session.get(".jline.terminal") : null;
        out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a("SUBSHELL").a(Ansi.Attribute.RESET));
        out.print("        ");
        if (subShell.getName() != null) {
            out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a(subShell.getName()).a(Ansi.Attribute.RESET));
            out.println();
        }
        out.print("\t");
        out.println(subShell.getDescription());
        out.println();
        if (subShell.getDetailedDescription() != null) {
            out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a("DETAILS").a(Ansi.Attribute.RESET));
            String desc = this.loadDescription(bundle, subShell.getDetailedDescription());
            while (desc.endsWith("\n")) {
                desc = desc.substring(0, desc.length() - 1);
            }
            DefaultActionPreparator.printFormatted("        ", desc, term != null ? term.getWidth() : 80, out);
        }
        out.println();
        out.println("${command-list|" + subShell.getName() + ":}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String loadDescription(Bundle bundle, String desc) {
        if (desc.startsWith("classpath:")) {
            URL url = bundle.getResource(desc.substring("classpath:".length()));
            if (url == null) {
                desc = "Unable to load description from " + desc;
            } else {
                InputStream is = null;
                try {
                    int c;
                    is = url.openStream();
                    InputStreamReader r = new InputStreamReader(is);
                    StringWriter sw = new StringWriter();
                    while ((c = ((Reader)r).read()) != -1) {
                        sw.append((char)c);
                    }
                    desc = sw.toString();
                }
                catch (IOException e) {
                    desc = "Unable to load description from " + desc;
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return desc;
    }
}

