/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.syncope;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncopeBackingEngine
implements BackingEngine {
    private final Logger logger = LoggerFactory.getLogger(SyncopeBackingEngine.class);
    private String address;
    private DefaultHttpClient client;

    public SyncopeBackingEngine(String address, String adminUser, String adminPassword) {
        this.address = address;
        this.client = new DefaultHttpClient();
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(adminUser, adminPassword);
        this.client.getCredentialsProvider().setCredentials(AuthScope.ANY, creds);
    }

    @Override
    public void addUser(String username, String password) {
        if (username.startsWith("_g_:")) {
            throw new IllegalArgumentException("Group prefix _g_: not permitted with Syncope backend");
        }
        HttpPost request = new HttpPost(this.address + "/users");
        String userTO = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><user><attributes><attribute><readonly>false</readonly><schema>fullname</schema><value>" + username + "</value></attribute>" + "<attribute><readonly>false</readonly><schema>surname</schema><value>" + username + "</value></attribute>" + "<attribute><readonly>false</readonly><schema>userId</schema><value>" + username + "@karaf.apache.org</value></attribute>" + "</attributes>" + "<password>" + password + "</password>" + "<username>" + username + "</username>" + "</user>";
        try {
            StringEntity entity = new StringEntity(userTO);
            request.setEntity(entity);
            CloseableHttpResponse closeableHttpResponse = this.client.execute(request);
        }
        catch (Exception e) {
            this.logger.error("Can't add user {}", (Object)username, (Object)e);
            throw new RuntimeException("Can't add user " + username, e);
        }
    }

    @Override
    public void deleteUser(String username) {
        if (username.startsWith("_g_:")) {
            throw new IllegalArgumentException("Group prefix _g_: not permitted with Syncope backend");
        }
        HttpDelete request = new HttpDelete(this.address + "/users/" + username);
        try {
            this.client.execute(request);
        }
        catch (Exception e) {
            this.logger.error("Can't delete user {}", (Object)username, (Object)e);
            throw new RuntimeException("Can't delete user " + username, e);
        }
    }

    @Override
    public List<UserPrincipal> listUsers() {
        ArrayList<UserPrincipal> users = new ArrayList<UserPrincipal>();
        HttpGet request = new HttpGet(this.address + "/users");
        try {
            CloseableHttpResponse response = this.client.execute(request);
            String responseTO = EntityUtils.toString(response.getEntity());
            if (responseTO != null && !responseTO.isEmpty()) {
                int index = responseTO.indexOf("<username>");
                while (index != -1) {
                    int end = (responseTO = responseTO.substring(index + "<username>".length())).indexOf("</username>");
                    if (end == -1) {
                        index = -1;
                    }
                    String username = responseTO.substring(0, end);
                    users.add(new UserPrincipal(username));
                    responseTO = responseTO.substring(end + "</username>".length());
                    index = responseTO.indexOf("<username>");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error listing users", e);
        }
        return users;
    }

    @Override
    public List<RolePrincipal> listRoles(Principal principal) {
        ArrayList<RolePrincipal> roles;
        block4: {
            roles = new ArrayList<RolePrincipal>();
            HttpGet request = new HttpGet(this.address + "/users?username=" + principal.getName());
            try {
                CloseableHttpResponse response = this.client.execute(request);
                String responseTO = EntityUtils.toString(response.getEntity());
                if (responseTO == null || responseTO.isEmpty()) break block4;
                int index = responseTO.indexOf("<roleName>");
                while (index != 1) {
                    int end = (responseTO = responseTO.substring(index + "<roleName>".length())).indexOf("</roleName>");
                    if (end == -1) {
                        index = -1;
                        break;
                    }
                    String role = responseTO.substring(0, end);
                    roles.add(new RolePrincipal(role));
                    responseTO = responseTO.substring(end + "</roleName>".length());
                    index = responseTO.indexOf("<roleName>");
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error listing roles", e);
            }
        }
        return roles;
    }

    @Override
    public void addRole(String username, String role) {
        throw new RuntimeException("Roles management should be done on the Syncope side");
    }

    @Override
    public void deleteRole(String username, String role) {
        throw new RuntimeException("Roles management should be done on the Syncope side");
    }

    @Override
    public List<GroupPrincipal> listGroups(UserPrincipal principal) {
        return new ArrayList<GroupPrincipal>();
    }

    @Override
    public void addGroup(String username, String group) {
        throw new RuntimeException("Group management is not supported by Syncope backend");
    }

    @Override
    public void deleteGroup(String username, String group) {
        throw new RuntimeException("Group management is not supported by Syncope backend");
    }

    @Override
    public void addGroupRole(String group, String role) {
        throw new RuntimeException("Group management is not supported by Syncope backend");
    }

    @Override
    public void deleteGroupRole(String group, String role) {
        throw new RuntimeException("Group management is not supported by Syncope backend");
    }

    @Override
    public Map<GroupPrincipal, String> listGroups() {
        throw new RuntimeException("Group management is not supported by Syncope backend");
    }

    @Override
    public void createGroup(String group) {
        throw new RuntimeException("Group management is not supported by Syncope backend");
    }
}

