/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.log;

import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.log.DisplayLog;
import org.apache.karaf.shell.log.layout.PatternConverter;
import org.apache.karaf.shell.log.layout.PatternParser;
import org.ops4j.pax.logging.spi.PaxAppender;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;

@Command(scope="log", name="tail", description="Continuously display log entries. Use ctrl-c to quit this command")
public class LogTail
extends DisplayLog {
    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    @Override
    protected Object doExecute() throws Exception {
        PrintEventThread printThread = new PrintEventThread();
        ReadKeyBoardThread readKeyboardThread = new ReadKeyBoardThread(Thread.currentThread());
        this.executorService.execute(printThread);
        this.executorService.execute(readKeyboardThread);
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        printThread.abort();
        readKeyboardThread.abort();
        this.executorService.shutdownNow();
        return null;
    }

    class PrintEventThread
    implements Runnable {
        boolean doDisplay = true;

        PrintEventThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PatternConverter cnv = new PatternParser(LogTail.this.overridenPattern != null ? LogTail.this.overridenPattern : LogTail.this.pattern).parse();
            PrintStream out = System.out;
            Iterable<PaxLoggingEvent> le = LogTail.this.events.getElements(LogTail.this.entries == 0 ? Integer.MAX_VALUE : LogTail.this.entries);
            for (PaxLoggingEvent event : le) {
                if (event == null) continue;
                LogTail.this.display(cnv, event, out);
            }
            final LinkedBlockingQueue queue = new LinkedBlockingQueue();
            PaxAppender appender = new PaxAppender(){

                public void doAppend(PaxLoggingEvent event) {
                    queue.add(event);
                }
            };
            try {
                LogTail.this.events.addAppender(appender);
                while (this.doDisplay) {
                    PaxLoggingEvent logEvent = (PaxLoggingEvent)queue.take();
                    if (logEvent == null) continue;
                    LogTail.this.display(cnv, logEvent, out);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                LogTail.this.events.removeAppender(appender);
            }
            out.println();
        }

        public void abort() {
            this.doDisplay = false;
        }
    }

    class ReadKeyBoardThread
    implements Runnable {
        private Thread sessionThread;
        boolean readKeyboard = true;

        public ReadKeyBoardThread(Thread thread) {
            this.sessionThread = thread;
        }

        public void abort() {
            this.readKeyboard = false;
        }

        @Override
        public void run() {
            while (this.readKeyboard) {
                try {
                    int c = LogTail.this.session.getKeyboard().read();
                    if (c >= 0) continue;
                    this.sessionThread.interrupt();
                }
                catch (IOException e) {}
                break;
            }
        }
    }
}

