/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.log;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ops4j.pax.logging.spi.PaxAppender;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;

public class LruList {
    private PaxLoggingEvent[] elements;
    private transient int start = 0;
    private transient int end = 0;
    private transient boolean full = false;
    private final int maxElements;
    private final List<PaxAppender> appenders;

    public LruList(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("The size must be greater than 0");
        }
        this.elements = new PaxLoggingEvent[size];
        this.maxElements = this.elements.length;
        this.appenders = new ArrayList<PaxAppender>();
    }

    public synchronized int size() {
        int size = 0;
        size = this.end < this.start ? this.maxElements - this.start + this.end : (this.end == this.start ? (this.full ? this.maxElements : 0) : this.end - this.start);
        return size;
    }

    public synchronized void clear() {
        this.start = 0;
        this.end = 0;
        this.elements = new PaxLoggingEvent[this.maxElements];
    }

    public synchronized void add(PaxLoggingEvent element) {
        PaxLoggingEvent e;
        if (null == element) {
            throw new NullPointerException("Attempted to add null object to buffer");
        }
        if (this.size() == this.maxElements && null != (e = this.elements[this.start])) {
            this.elements[this.start++] = null;
            if (this.start >= this.maxElements) {
                this.start = 0;
            }
            this.full = false;
        }
        this.elements[this.end++] = element;
        if (this.end >= this.maxElements) {
            this.end = 0;
        }
        if (this.end == this.start) {
            this.full = true;
        }
        for (PaxAppender appender : this.appenders) {
            try {
                appender.doAppend(element);
            }
            catch (Throwable throwable) {}
        }
    }

    public synchronized Iterable<PaxLoggingEvent> getElements() {
        return this.getElements(this.size());
    }

    public synchronized Iterable<PaxLoggingEvent> getElements(int nb) {
        int s = this.size();
        nb = Math.min(Math.max(0, nb), s);
        PaxLoggingEvent[] e = new PaxLoggingEvent[nb];
        for (int i = 0; i < nb; ++i) {
            e[i] = this.elements[(i + s - nb + this.start) % this.maxElements];
        }
        return Arrays.asList(e);
    }

    public synchronized void addAppender(PaxAppender appender) {
        this.appenders.add(appender);
    }

    public synchronized void removeAppender(PaxAppender appender) {
        this.appenders.remove(appender);
    }
}

