/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.osgi;

import jline.console.ConsoleReader;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.osgi.BundleCommand;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.startlevel.StartLevel;

@Command(scope="osgi", name="bundle-level", description="Gets or sets the start level of a given bundle.")
public class BundleLevel
extends BundleCommand {
    @Argument(index=1, name="startLevel", description="The bundle's new start level", required=false, multiValued=false)
    Integer level;

    @Override
    protected void doExecute(Bundle bundle) throws Exception {
        ServiceReference ref = this.getBundleContext().getServiceReference(StartLevel.class.getName());
        if (ref == null) {
            System.out.println("StartLevel service is unavailable.");
            return;
        }
        StartLevel sl = (StartLevel)this.getService(StartLevel.class, ref);
        if (sl == null) {
            System.out.println("StartLevel service is unavailable.");
            return;
        }
        if (this.level == null) {
            System.out.println("Level " + sl.getBundleStartLevel(bundle));
        } else if (this.level < 50 && sl.getBundleStartLevel(bundle) > 50 && !this.force) {
            String str;
            do {
                String msg;
                ConsoleReader reader;
                if (!"yes".equalsIgnoreCase(str = (reader = (ConsoleReader)this.session.get(".jline.reader")).readLine(msg = "You are about to designate bundle as a system bundle.  Do you wish to continue (yes/no): "))) continue;
                sl.setBundleStartLevel(bundle, this.level.intValue());
                break;
            } while (!"no".equalsIgnoreCase(str));
        } else {
            sl.setBundleStartLevel(bundle, this.level.intValue());
        }
    }
}

