/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.osgi;

import java.util.List;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.service.command.Function;
import org.apache.karaf.shell.osgi.BundlesCommand;
import org.apache.karaf.shell.osgi.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

@Command(scope="osgi", name="bundle-services", description="List OSGi services per bundle")
public class ListBundleServices
extends BundlesCommand {
    @Option(name="-a", aliases={}, description="Shows all services. (By default Karaf commands are hidden)", required=false, multiValued=false)
    boolean showAll;
    @Option(name="-u", aliases={}, description="Shows the services each bundle uses. (By default the provided services are shown)", required=false, multiValued=false)
    boolean inUse;
    @Option(name="-p", aliases={}, description="Shows the properties of the services", required=false, multiValued=false)
    boolean showProperties = false;

    @Override
    protected void doExecute(List<Bundle> bundles) throws Exception {
        for (Bundle bundle : bundles) {
            ServiceReference[] refs = this.inUse ? bundle.getServicesInUse() : bundle.getRegisteredServices();
            this.printServices(bundle, refs, this.showProperties);
        }
    }

    private void printServices(Bundle bundle, ServiceReference[] refs, boolean showProperties) {
        boolean headerPrinted = false;
        boolean needSeparator = false;
        if (refs == null) {
            return;
        }
        for (ServiceReference serviceRef : refs) {
            boolean print;
            String[] objectClass = (String[])serviceRef.getProperty("objectClass");
            boolean bl = print = this.showAll || !this.isCommand(objectClass);
            if (!headerPrinted) {
                headerPrinted = true;
                System.out.println("");
                String title = bundle.getSymbolicName() + (this.inUse ? " uses:" : " provides:");
                System.out.println(title);
                System.out.println("----------------------------------");
            }
            if (!print) continue;
            if (needSeparator && showProperties) {
                System.out.println("----");
            }
            if (showProperties) {
                this.printProperties(serviceRef);
            } else {
                System.out.println(Util.getValueString(objectClass));
            }
            needSeparator = true;
        }
    }

    private boolean isCommand(String[] objectClasses) {
        for (String objectClass : objectClasses) {
            if (!objectClass.equals(Function.class.getName())) continue;
            return true;
        }
        return false;
    }

    private void printProperties(ServiceReference serviceRef) {
        for (String key : serviceRef.getPropertyKeys()) {
            System.out.println(key + " = " + Util.getValueString(serviceRef.getProperty(key)));
        }
    }
}

