/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.dev;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.dev.AbstractBundleCommand;
import org.apache.karaf.util.bundles.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="dev", name="dynamic-import", description="Enables/disables dynamic-import for a given bundle.")
public class DynamicImport
extends AbstractBundleCommand {
    private final Logger LOG = LoggerFactory.getLogger(DynamicImport.class);
    protected static final String ORIGINAL_WIRES = "Original-Wires";

    @Override
    protected void doExecute(Bundle bundle) throws Exception {
        if (bundle.getHeaders().get(ORIGINAL_WIRES) == null) {
            this.enableDynamicImports(bundle);
        } else {
            this.disableDynamicImports(bundle);
        }
    }

    private void enableDynamicImports(Bundle bundle) throws IOException, BundleException {
        System.out.printf("Enabling dynamic imports on bundle %s%n", bundle);
        String orgLocation = this.getLocation(bundle);
        String location = String.format("wrap:%s$Bundle-UpdateLocation=%s&DynamicImport-Package=*&%s=%s&overwrite=merge", orgLocation, orgLocation, ORIGINAL_WIRES, this.explode(this.getWiredBundles(bundle).keySet()));
        this.LOG.debug(String.format("Updating %s with URL %s", bundle, location));
        URL url = new URL(location);
        bundle.update(url.openStream());
        this.getPackageAdmin().refreshPackages(new Bundle[]{bundle});
    }

    private String getLocation(Bundle bundle) {
        String location = (String)bundle.getHeaders().get("Bundle-UpdateLocation");
        return location != null ? location : bundle.getLocation();
    }

    private void disableDynamicImports(Bundle bundle) throws IOException, BundleException {
        System.out.printf("Disabling dynamic imports on bundle %s%n", bundle);
        Set<String> current = this.getWiredBundles(bundle).keySet();
        for (String original : ((String)bundle.getHeaders().get(ORIGINAL_WIRES)).toString().split(",")) {
            current.remove(original);
        }
        if (current.isEmpty()) {
            System.out.println("(no additional packages have been wired since dynamic import was enabled)");
        } else {
            System.out.printf("%nAdditional packages wired since dynamic import was enabled:%n", new Object[0]);
            for (String pkg : current) {
                System.out.printf("- %s%n", pkg);
            }
        }
        BundleUtils.update(bundle);
    }

    private String explode(Set<String> set) {
        StringBuffer result = new StringBuffer();
        Iterator<String> it = set.iterator();
        while (it.hasNext()) {
            result.append(it.next());
            if (!it.hasNext()) continue;
            result.append(",");
        }
        if (result.length() == 0) {
            return "--none--";
        }
        return result.toString();
    }
}

