/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Dictionary;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.shell.console.AbstractAction;
import org.apache.karaf.shell.console.BundleContextAware;
import org.apache.karaf.shell.console.CloseShellException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="shell", name="logout", description="Disconnects shell from current session.")
public class LogoutAction
extends AbstractAction
implements BundleContextAware {
    protected BundleContext bundleContext;

    protected Object doExecute() throws Exception {
        this.log.info("Disconnecting from current session...");
        ConfigurationAdmin admin = this.getConfigurationAdmin();
        Configuration configuration = admin.getConfiguration("org.apache.karaf.shell");
        Dictionary properties = configuration.getProperties();
        String realm = (String)properties.get("sshRealm");
        AccessControlContext context = AccessController.getContext();
        Subject subject = Subject.getSubject(context);
        Set<UserPrincipal> principals = subject.getPrincipals(UserPrincipal.class);
        final String username = principals.iterator().next().getName();
        LoginContext loginContext = new LoginContext(realm, subject, new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (!(callback instanceof NameCallback)) {
                        throw new UnsupportedCallbackException(callback);
                    }
                    ((NameCallback)callback).setName(username);
                }
            }
        });
        loginContext.logout();
        throw new CloseShellException();
    }

    protected ConfigurationAdmin getConfigurationAdmin() {
        ServiceReference ref = this.getBundleContext().getServiceReference(ConfigurationAdmin.class.getName());
        if (ref == null) {
            return null;
        }
        ConfigurationAdmin admin = (ConfigurationAdmin)this.getBundleContext().getService(ref);
        if (admin == null) {
            return null;
        }
        return admin;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

