/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.karaf.main.Main;
import org.apache.karaf.main.Utils;

public class Stop {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        File karafHome = Utils.getKarafHome();
        File karafBase = Utils.getKarafDirectory("karaf.base", "KARAF_BASE", karafHome, false, true);
        File karafData = Utils.getKarafDirectory("karaf.data", "KARAF_DATA", new File(karafBase.getPath(), "data"), true, true);
        System.setProperty("karaf.home", karafHome.getPath());
        System.setProperty("karaf.base", karafBase.getPath());
        System.setProperty("karaf.data", karafData.getPath());
        Main.loadSystemProperties(karafBase);
        File file = new File(new File(karafBase, "etc"), "config.properties");
        URL configPropURL = file.toURI().toURL();
        Properties props = Main.loadPropertiesFile(configPropURL, false);
        Main.copySystemProperties(props);
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            props.setProperty(name, Main.substVars(props.getProperty(name), name, null, props));
        }
        int port = Integer.parseInt(props.getProperty("karaf.shutdown.port", "0"));
        String host = props.getProperty("karaf.shutdown.host", "localhost");
        String portFile = props.getProperty("karaf.shutdown.port.file");
        String shutdown = props.getProperty("karaf.shutdown.command", "SHUTDOWN");
        if (port == 0 && portFile != null) {
            try {
                BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(portFile)));
                String portStr = r.readLine();
                port = Integer.parseInt(portStr);
                r.close();
            }
            catch (FileNotFoundException fnfe) {
                System.err.println(portFile + " shutdown port file doesn't exist. The container is not running.");
                System.exit(3);
            }
            catch (IOException ioe) {
                System.err.println("Can't read the " + portFile + " shutdown port file: " + ioe.getMessage());
                System.exit(4);
            }
        }
        if (port > 0) {
            try (Socket s = null;){
                s = new Socket(host, port);
                s.getOutputStream().write(shutdown.getBytes());
            }
        } else {
            System.err.println("Unable to find port...");
            System.exit(2);
        }
    }
}

