/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.command;

import java.util.LinkedList;
import java.util.Queue;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.jaas.command.JaasCommandSupport;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.jaas.modules.BackingEngine;

@Command(scope="jaas", name="update", description="Update the selected JAAS Realm")
public class UpdateCommand
extends JaasCommandSupport {
    @Override
    protected Object doExecute() throws Exception {
        JaasRealm realm = (JaasRealm)this.session.get("JaasCommand.REALM");
        AppConfigurationEntry entry = (AppConfigurationEntry)this.session.get("JaasCommand.ENTRY");
        if (realm == null || entry == null) {
            System.err.println("No JAAS Realm/Login Module selected");
            return null;
        }
        BackingEngine engine = this.backingEngineService.get(entry);
        if (engine == null) {
            System.err.println("Can't update the JAAS realm (no backing engine service registered)");
            return null;
        }
        return this.doExecute(engine);
    }

    @Override
    protected Object doExecute(BackingEngine engine) throws Exception {
        Queue commands = (Queue)this.session.get("JaasCommand.COMMANDS");
        if (commands == null || commands.isEmpty()) {
            System.err.println("No pending modification");
            return null;
        }
        while (!commands.isEmpty()) {
            Object obj = commands.remove();
            if (!(obj instanceof JaasCommandSupport)) continue;
            ((JaasCommandSupport)((Object)obj)).doExecute(engine);
        }
        this.session.put("JaasCommand.REALM", null);
        this.session.put("JaasCommand.ENTRY", null);
        this.session.put("JaasCommand.COMMANDS", new LinkedList());
        return null;
    }
}

