/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.dev.framework;

import java.io.File;
import java.io.IOException;
import org.apache.karaf.shell.dev.framework.Framework;
import org.apache.karaf.shell.dev.util.IO;

public class Equinox
extends Framework {
    public static final String NAME = "Equinox";

    public Equinox(File base) {
        super(base);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void enableDebug(File directory) throws IOException {
        this.setConfigProperty("osgi.debug", "etc/equinox-debug.properties");
        this.saveConfigProperties();
        System.out.printf("- set osgi.debug=etc/equinox-debug.properties in etc/config.properties%n", new Object[0]);
        File debug = new File(directory, "etc/equinox-debug.properties");
        if (!debug.exists()) {
            IO.copyTextToFile(Equinox.class.getResourceAsStream("equinox-debug.properties"), debug);
            System.out.printf("- created etc/equinox-debug.properties to configure Equinox debugging options%n", new Object[0]);
        }
        System.out.printf("%nEnable specific debug options in etc/equinox-debug.properties%n", new Object[0]);
        System.out.printf("and restart Karaf now to enable Equinox debug logging%n", new Object[0]);
    }

    @Override
    public void disableDebug(File directory) throws IOException {
        this.removeConfigProperty("osgi.debug");
        this.saveConfigProperties();
        System.out.printf("- removed osgi.debug from etc/config.properties%n%n", new Object[0]);
        System.out.printf("Restart Karaf now to disable Equinox debug logging%n", new Object[0]);
    }
}

