/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.admin.management.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.TabularData;
import org.apache.karaf.admin.AdminService;
import org.apache.karaf.admin.Instance;
import org.apache.karaf.admin.InstanceSettings;
import org.apache.karaf.admin.management.AdminServiceMBean;
import org.apache.karaf.admin.management.codec.JmxInstance;

public class AdminServiceMBeanImpl
extends StandardMBean
implements AdminServiceMBean {
    private AdminService adminService;

    public AdminServiceMBeanImpl() throws NotCompliantMBeanException {
        super(AdminServiceMBean.class);
    }

    public AdminService getAdminService() {
        return this.adminService;
    }

    public void setAdminService(AdminService adminService) {
        this.adminService = adminService;
    }

    @Override
    public int createInstance(String name, InstanceSettings settings) throws Exception {
        Instance inst = this.adminService.createInstance(name, settings, false);
        if (inst != null) {
            return inst.getPid();
        }
        return -1;
    }

    @Override
    public int createInstance(String name, int sshPort, int rmiRegistryPort, int rmiServerPort, String location, String javaOpts, String features, String featureURLs) throws Exception {
        return this.createInstance(name, sshPort, rmiRegistryPort, rmiServerPort, location, javaOpts, features, featureURLs, "0.0.0.0");
    }

    @Override
    public int createInstance(String name, int sshPort, int rmiRegistryPort, int rmiServerPort, String location, String javaOpts, String features, String featureURLs, String address) throws Exception {
        InstanceSettings settings;
        Instance inst;
        if ("".equals(location)) {
            location = null;
        }
        if ("".equals(javaOpts)) {
            javaOpts = null;
        }
        if ((inst = this.adminService.createInstance(name, settings = new InstanceSettings(sshPort, rmiRegistryPort, rmiServerPort, location, javaOpts, this.parseStringList(featureURLs), this.parseStringList(features), new HashMap(), new HashMap(), address), false)) != null) {
            return inst.getPid();
        }
        return -1;
    }

    @Override
    public void changeSshPort(String name, int port) throws Exception {
        this.getExistingInstance(name).changeSshPort(port);
    }

    @Override
    public void changeSshHost(String name, String host) throws Exception {
        this.getExistingInstance(name).changeSshHost(host);
    }

    @Override
    public void changeRmiRegistryPort(String name, int port) throws Exception {
        this.getExistingInstance(name).changeRmiRegistryPort(port);
    }

    @Override
    public void changeRmiServerPort(String name, int port) throws Exception {
        this.getExistingInstance(name).changeRmiServerPort(port);
    }

    @Override
    public void changeJavaOpts(String name, String javaOpts) throws Exception {
        this.getExistingInstance(name).changeJavaOpts(javaOpts);
    }

    @Override
    public void destroyInstance(String name) throws Exception {
        this.getExistingInstance(name).destroy();
    }

    @Override
    public void startInstance(String name) throws Exception {
        this.getExistingInstance(name).start(null);
    }

    @Override
    public void startInstance(String name, String opts) throws Exception {
        this.getExistingInstance(name).start(opts);
    }

    @Override
    public void startInstance(String name, String opts, boolean wait) throws Exception {
        Instance child = this.getExistingInstance(name);
        if (wait) {
            String state = child.getState();
            if ("Stopped".equals(state)) {
                child.start(opts);
            }
            if (!"Started".equals(state)) {
                do {
                    Thread.sleep(500L);
                } while ("Starting".equals(state = child.getState()));
            }
        } else {
            child.start(opts);
        }
    }

    @Override
    public void stopInstance(String name) throws Exception {
        this.getExistingInstance(name).stop();
    }

    @Override
    public void renameInstance(String originalName, String newName) throws Exception {
        this.adminService.renameInstance(originalName, newName, false);
    }

    @Override
    public void cloneInstance(String name, String cloneName, InstanceSettings settings) throws Exception {
        this.adminService.cloneInstance(name, cloneName, settings, false);
    }

    @Override
    public void cloneInstance(String name, String cloneName, int sshPort, int rmiRegistryPort, int rmiServerPort, String location, String javaOpts) throws Exception {
        if ("".equals(location)) {
            location = null;
        }
        if ("".equals(javaOpts)) {
            javaOpts = null;
        }
        InstanceSettings settings = new InstanceSettings(sshPort, rmiRegistryPort, rmiServerPort, location, javaOpts, null, null);
        this.adminService.cloneInstance(name, cloneName, settings, false);
    }

    @Override
    public TabularData getInstances() throws Exception {
        List<Instance> allInstances = Arrays.asList(this.adminService.getInstances());
        ArrayList<JmxInstance> instances = new ArrayList<JmxInstance>();
        for (Instance instance : allInstances) {
            try {
                instances.add(new JmxInstance(instance));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        TabularData table = JmxInstance.tableFrom(instances);
        return table;
    }

    private Instance getExistingInstance(String name) {
        Instance i = this.adminService.getInstance(name);
        if (i == null) {
            throw new IllegalArgumentException("Instance '" + name + "' does not exist");
        }
        return i;
    }

    private List<String> parseStringList(String value) {
        ArrayList<String> list = new ArrayList<String>();
        if (value != null) {
            for (String el : value.split(",")) {
                String trimmed = el.trim();
                if (trimmed.length() == 0) continue;
                list.add(trimmed);
            }
        }
        return list;
    }
}

