/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.common;

import java.io.IOException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.Buffer;

public abstract class AbstractAgentProxy
implements SshAgent {
    @Override
    public List<SshAgent.Pair<PublicKey, String>> getIdentities() throws IOException {
        Buffer buffer = this.createBuffer((byte)11);
        byte type = (buffer = this.request(this.prepare(buffer))).getByte();
        if (type != 12) {
            throw new SshException("SSH agent failure");
        }
        int nbIdentities = buffer.getInt();
        if (nbIdentities > 1024) {
            throw new SshException("SSH agent failure");
        }
        ArrayList<SshAgent.Pair<PublicKey, String>> keys = new ArrayList<SshAgent.Pair<PublicKey, String>>();
        for (int i = 0; i < nbIdentities; ++i) {
            PublicKey key = buffer.getPublicKey();
            keys.add(new SshAgent.Pair<PublicKey, String>(key, buffer.getString()));
        }
        return keys;
    }

    @Override
    public byte[] sign(PublicKey key, byte[] data) throws IOException {
        Buffer buffer = this.createBuffer((byte)13);
        buffer.putPublicKey(key);
        buffer.putBytes(data);
        buffer.putInt(0L);
        buffer = this.request(this.prepare(buffer));
        if (buffer.getByte() != 14) {
            throw new SshException("SSH agent failure");
        }
        Buffer buf = new Buffer(buffer.getBytes());
        buf.getString();
        return buf.getBytes();
    }

    @Override
    public void addIdentity(KeyPair key, String comment) throws IOException {
        Buffer buffer = this.createBuffer((byte)17);
        buffer.putKeyPair(key);
        buffer.putString(comment);
        buffer = this.request(this.prepare(buffer));
        if (buffer.available() != 1 || buffer.getByte() != 6) {
            throw new SshException("SSH agent failure");
        }
    }

    @Override
    public void removeIdentity(PublicKey key) throws IOException {
        Buffer buffer = this.createBuffer((byte)18);
        buffer.putPublicKey(key);
        buffer = this.request(this.prepare(buffer));
        if (buffer.available() != 1 || buffer.getByte() != 6) {
            throw new SshException("SSH agent failure");
        }
    }

    @Override
    public void removeAllIdentities() throws IOException {
        Buffer buffer = this.createBuffer((byte)19);
        if ((buffer = this.request(this.prepare(buffer))).available() != 1 || buffer.getByte() != 6) {
            throw new SshException("SSH agent failure");
        }
    }

    @Override
    public void close() {
    }

    protected Buffer createBuffer(byte cmd) {
        Buffer buffer = new Buffer();
        buffer.putInt(0L);
        buffer.putByte(cmd);
        return buffer;
    }

    protected Buffer prepare(Buffer buffer) {
        int wpos = buffer.wpos();
        buffer.wpos(0);
        buffer.putInt(wpos - 4);
        buffer.wpos(wpos);
        return buffer;
    }

    protected abstract Buffer request(Buffer var1) throws IOException;
}

