/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.local;

import java.io.IOException;
import java.util.UUID;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentServer;
import org.apache.sshd.agent.local.AgentForwardedChannel;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.session.ConnectionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentServerProxy
implements SshAgentServer {
    private static final Logger LOG = LoggerFactory.getLogger(AgentServerProxy.class);
    private final ConnectionService service;
    private String id;

    public AgentServerProxy(ConnectionService service) throws IOException {
        this.service = service;
        this.id = UUID.randomUUID().toString();
    }

    public SshAgent createClient() throws IOException {
        try {
            AgentForwardedChannel channel = new AgentForwardedChannel();
            this.service.registerChannel(channel);
            OpenFuture future = (OpenFuture)channel.open().await();
            Throwable t = future.getException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t != null) {
                throw new Exception(t);
            }
            return channel.getAgent();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void close() {
    }
}

