/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.local;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.common.AbstractAgentClient;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.server.channel.AbstractServerChannel;

public class ChannelAgentForwarding
extends AbstractServerChannel {
    private String authSocket;
    private long pool;
    private long handle;
    private Thread thread;
    private OutputStream out;
    private SshAgent agent;
    private AgentClient client;

    @Override
    protected OpenFuture doInit(Buffer buffer) {
        DefaultOpenFuture f = new DefaultOpenFuture(this);
        try {
            this.out = new ChannelOutputStream(this, this.remoteWindow, this.log, 94);
            this.agent = this.session.getFactoryManager().getAgentFactory().createClient(this.session.getFactoryManager());
            this.client = new AgentClient();
            f.setOpened();
        }
        catch (Exception e) {
            f.setException(e);
        }
        return f;
    }

    private void closeImmediately0() {
        super.close(true);
    }

    @Override
    public CloseFuture close(boolean immediately) {
        return super.close(immediately).addListener(new SshFutureListener<CloseFuture>(){

            @Override
            public void operationComplete(CloseFuture sshFuture) {
                ChannelAgentForwarding.this.closeImmediately0();
            }
        });
    }

    @Override
    public void handleEof() throws IOException {
        super.handleEof();
    }

    @Override
    protected void doWriteData(byte[] data, int off, int len) throws IOException {
        this.client.messageReceived(new Buffer(data, off, len));
    }

    @Override
    protected void doWriteExtendedData(byte[] data, int off, int len) throws IOException {
        throw new UnsupportedOperationException("AgentForward channel does not support extended data");
    }

    protected class AgentClient
    extends AbstractAgentClient {
        public AgentClient() {
            super(ChannelAgentForwarding.this.agent);
        }

        @Override
        protected void reply(Buffer buf) throws IOException {
            ChannelAgentForwarding.this.out.write(buf.array(), buf.rpos(), buf.available());
            ChannelAgentForwarding.this.out.flush();
        }
    }

    public static class Factory
    implements NamedFactory<Channel> {
        @Override
        public String getName() {
            return "auth-agent@openssh.com";
        }

        @Override
        public Channel create() {
            return new ChannelAgentForwarding();
        }
    }
}

