/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.local;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.SshAgentServer;
import org.apache.sshd.agent.local.AgentServerProxy;
import org.apache.sshd.agent.local.ChannelAgentForwarding;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.server.session.ServerSession;

public class ProxyAgentFactory
implements SshAgentFactory {
    private final Map<String, AgentServerProxy> proxies = new ConcurrentHashMap<String, AgentServerProxy>();

    @Override
    public NamedFactory<Channel> getChannelForwardingFactory() {
        return new ChannelAgentForwarding.Factory();
    }

    @Override
    public SshAgent createClient(FactoryManager manager) throws IOException {
        String proxyId = manager.getProperties().get("SSH_AUTH_SOCK");
        if (proxyId == null) {
            throw new IllegalStateException("No SSH_AUTH_SOCK environment variable set");
        }
        AgentServerProxy proxy = this.proxies.get(proxyId);
        if (proxy == null) {
            throw new IllegalStateException("No ssh agent found");
        }
        return proxy.createClient();
    }

    @Override
    public SshAgentServer createServer(ConnectionService service) throws IOException {
        Session session = service.getSession();
        if (!(session instanceof ServerSession)) {
            throw new IllegalStateException("The session used to create an agent server proxy must be a server session");
        }
        final AgentServerProxy proxy = new AgentServerProxy(service);
        this.proxies.put(proxy.getId(), proxy);
        return new SshAgentServer(){

            @Override
            public String getId() {
                return proxy.getId();
            }

            @Override
            public void close() {
                ProxyAgentFactory.this.proxies.remove(proxy.getId());
                proxy.close();
            }
        };
    }
}

