/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.unix;

import java.io.IOException;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.common.AbstractAgentClient;
import org.apache.sshd.agent.local.AgentImpl;
import org.apache.sshd.agent.unix.AprLibrary;
import org.apache.sshd.common.util.Buffer;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.Local;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.Socket;

public class AgentServer {
    private final SshAgent agent;
    private String authSocket;
    private long pool;
    private long handle;
    private Thread thread;

    public AgentServer() {
        this(new AgentImpl());
    }

    public AgentServer(SshAgent agent) {
        this.agent = agent;
    }

    public SshAgent getAgent() {
        return this.agent;
    }

    public String start() throws Exception {
        this.authSocket = AprLibrary.createLocalSocketAddress();
        this.pool = Pool.create((long)AprLibrary.getInstance().getRootPool());
        this.handle = Local.create((String)this.authSocket, (long)this.pool);
        int result = Local.bind((long)this.handle, (long)0L);
        if (result != 0) {
            AgentServer.throwException(result);
        }
        AprLibrary.secureLocalSocket(this.authSocket, this.handle);
        result = Local.listen((long)this.handle, (int)0);
        if (result != 0) {
            AgentServer.throwException(result);
        }
        this.thread = new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        long clientSock = Local.accept((long)AgentServer.this.handle);
                        Socket.timeoutSet((long)clientSock, (long)10000000L);
                        new SshAgentSession(clientSock, AgentServer.this.agent);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        };
        this.thread.start();
        return this.authSocket;
    }

    public void close() {
        this.agent.close();
        Socket.close((long)this.handle);
    }

    private static void throwException(int code) throws IOException {
        throw new IOException(Error.strerror((int)(-code)) + " (code: " + code + ")");
    }

    protected static class SshAgentSession
    extends AbstractAgentClient
    implements Runnable {
        private final long socket;

        public SshAgentSession(long socket, SshAgent agent) {
            super(agent);
            this.socket = socket;
            new Thread(this).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int result;
                byte[] buf = new byte[1024];
                while ((result = Socket.recv((long)this.socket, (byte[])buf, (int)0, (int)buf.length)) != -70014) {
                    if (result < 0) {
                        AgentServer.throwException(result);
                    }
                    this.messageReceived(new Buffer(buf, 0, result));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Socket.close((long)this.socket);
            }
        }

        @Override
        protected void reply(Buffer buf) throws IOException {
            int result = Socket.send((long)this.socket, (byte[])buf.array(), (int)buf.rpos(), (int)buf.available());
            if (result < 0) {
                AgentServer.throwException(result);
            }
        }
    }
}

