/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.sshd.ClientSession;
import org.apache.sshd.client.UserAuth;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.util.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAuthPassword
implements UserAuth {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private ClientSession session;
    private String service;
    private Iterator<String> passwords;
    private String current;

    @Override
    public void init(ClientSession session, String service, List<Object> identities) throws Exception {
        this.session = session;
        this.service = service;
        ArrayList<String> pwds = new ArrayList<String>();
        for (Object o : identities) {
            if (!(o instanceof String)) continue;
            pwds.add((String)o);
        }
        this.passwords = pwds.iterator();
    }

    @Override
    public boolean process(Buffer buffer) throws Exception {
        if (buffer == null) {
            if (this.passwords.hasNext()) {
                this.current = this.passwords.next();
                this.log.debug("Send SSH_MSG_USERAUTH_REQUEST for password");
                buffer = this.session.createBuffer((byte)50);
                buffer.putString(this.session.getUsername());
                buffer.putString(this.service);
                buffer.putString("password");
                buffer.putByte((byte)0);
                buffer.putString(this.current);
                this.session.writePacket(buffer);
                return true;
            }
            return false;
        }
        byte cmd = buffer.getByte();
        if (cmd == 60) {
            String prompt = buffer.getString();
            String lang = buffer.getString();
            this.log.warn("Password change requested, but not supported");
            return false;
        }
        throw new IllegalStateException("Received unknown packet");
    }

    @Override
    public void destroy() {
    }

    public static class Factory
    implements NamedFactory<UserAuth> {
        @Override
        public String getName() {
            return "password";
        }

        @Override
        public UserAuth create() {
            return new UserAuthPassword();
        }
    }
}

