/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.deprecated;

import java.io.IOException;
import org.apache.sshd.client.auth.deprecated.AbstractUserAuth;
import org.apache.sshd.client.auth.deprecated.UserAuth;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.util.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAuthPassword
extends AbstractUserAuth {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String password;

    public UserAuthPassword(ClientSessionImpl session, String service, String password) {
        super(session, service);
        this.password = password;
    }

    @Override
    public UserAuth.Result next(Buffer buffer) throws IOException {
        if (buffer == null) {
            this.log.debug("Send SSH_MSG_USERAUTH_REQUEST for password");
            buffer = this.session.createBuffer((byte)50);
            buffer.putString(this.session.getUsername());
            buffer.putString(this.service);
            buffer.putString("password");
            buffer.putByte((byte)0);
            buffer.putString(this.password);
            this.session.writePacket(buffer);
            return UserAuth.Result.Continued;
        }
        byte cmd = buffer.getByte();
        if (cmd == 52) {
            this.log.debug("Received SSH_MSG_USERAUTH_SUCCESS");
            return UserAuth.Result.Success;
        }
        if (cmd == 51) {
            this.log.debug("Received SSH_MSG_USERAUTH_FAILURE");
            return UserAuth.Result.Failure;
        }
        this.log.debug("Received unkown packet {}", (Object)cmd);
        return UserAuth.Result.Continued;
    }
}

