/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.IOException;
import org.apache.sshd.client.channel.ChannelSession;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.Buffer;

public class ChannelSubsystem
extends ChannelSession {
    private final String subsystem;

    public ChannelSubsystem(String subsystem) {
        if (subsystem == null) {
            throw new IllegalArgumentException("subsystem must not be null");
        }
        this.subsystem = subsystem;
    }

    @Override
    protected void doOpen() throws IOException {
        this.log.debug("Send SSH_MSG_CHANNEL_REQUEST exec");
        Buffer buffer = this.session.createBuffer((byte)98);
        buffer.putInt(this.recipient);
        buffer.putString("subsystem");
        buffer.putBoolean(false);
        buffer.putString(this.subsystem);
        this.writePacket(buffer);
        super.doOpen();
    }

    public void onClose(final Runnable run) {
        this.closeFuture.addListener(new SshFutureListener<CloseFuture>(){

            @Override
            public void operationComplete(CloseFuture future) {
                run.run();
            }
        });
    }
}

