/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.kex;

import java.security.PublicKey;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.Digest;
import org.apache.sshd.common.KeyExchange;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Signature;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.kex.AbstractDH;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.KeyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDHGClient
implements KeyExchange {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ClientSessionImpl session;
    private byte[] V_S;
    private byte[] V_C;
    private byte[] I_S;
    private byte[] I_C;
    private Digest hash;
    private AbstractDH dh;
    private byte[] e;
    private byte[] f;
    private byte[] K;
    private byte[] H;
    private PublicKey serverKey;

    @Override
    public void init(AbstractSession s, byte[] V_S, byte[] V_C, byte[] I_S, byte[] I_C) throws Exception {
        if (!(s instanceof ClientSessionImpl)) {
            throw new IllegalStateException("Using a client side KeyExchange on a server");
        }
        this.session = (ClientSessionImpl)s;
        this.V_S = V_S;
        this.V_C = V_C;
        this.I_S = I_S;
        this.I_C = I_C;
        this.dh = this.getDH();
        this.hash = this.dh.getHash();
        this.hash.init();
        this.e = this.dh.getE();
        this.log.debug("Send SSH_MSG_KEXDH_INIT");
        Buffer buffer = s.createBuffer((byte)30);
        buffer.putMPInt(this.e);
        this.session.writePacket(buffer);
    }

    protected abstract AbstractDH getDH() throws Exception;

    @Override
    public boolean next(Buffer buffer) throws Exception {
        byte cmd = buffer.getByte();
        if (cmd != 31) {
            throw new SshException(3, "Protocol error: expected packet SSH_MSG_KEXDH_REPLY, got " + cmd);
        }
        this.log.debug("Received SSH_MSG_KEXDH_REPLY");
        byte[] K_S = buffer.getBytes();
        this.f = buffer.getMPIntAsBytes();
        byte[] sig = buffer.getBytes();
        this.dh.setF(this.f);
        this.K = this.dh.getK();
        buffer = new Buffer(K_S);
        this.serverKey = buffer.getRawPublicKey();
        String keyAlg = KeyUtils.getKeyType(this.serverKey);
        if (keyAlg == null) {
            throw new SshException("Unsupported server key type");
        }
        buffer = new Buffer();
        buffer.putString(this.V_C);
        buffer.putString(this.V_S);
        buffer.putString(this.I_C);
        buffer.putString(this.I_S);
        buffer.putString(K_S);
        buffer.putMPInt(this.e);
        buffer.putMPInt(this.f);
        buffer.putMPInt(this.K);
        this.hash.update(buffer.array(), 0, buffer.available());
        this.H = this.hash.digest();
        Signature verif = (Signature)NamedFactory.Utils.create(this.session.getFactoryManager().getSignatureFactories(), keyAlg);
        verif.init(this.serverKey, null);
        verif.update(this.H, 0, this.H.length);
        if (!verif.verify(sig)) {
            throw new SshException(3, "KeyExchange signature verification failed");
        }
        return true;
    }

    @Override
    public Digest getHash() {
        return this.hash;
    }

    @Override
    public byte[] getH() {
        return this.H;
    }

    @Override
    public byte[] getK() {
        return this.K;
    }

    @Override
    public PublicKey getServerKey() {
        return this.serverKey;
    }
}

