/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.keyverifier;

import java.net.SocketAddress;
import java.security.PublicKey;
import java.util.Map;
import org.apache.sshd.ClientSession;
import org.apache.sshd.client.ServerKeyVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingServerKeyVerifier
implements ServerKeyVerifier {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean verifyServerKey(ClientSession sshClientSession, SocketAddress remoteAddress, PublicKey serverKey) {
        Map<Object, Object> metadataMap = sshClientSession.getMetadataMap();
        Object verifier = metadataMap.get(ServerKeyVerifier.class);
        if (verifier == null) {
            this.log.trace("No verifier found in ClientSession metadata; accepting server key");
            return true;
        }
        return ((ServerKeyVerifier)verifier).verifyServerKey(sshClientSession, remoteAddress, serverKey);
    }
}

